/*
 * Decompiled with CFR 0.152.
 */
package trees;

import files.ParsingTools;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutableNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = -3012174557942213624L;
    protected String key;

    public MutableNode(Object obj, boolean allowsChildren) {
        super(obj, allowsChildren);
        this.key = obj.toString();
    }

    public MutableNode(Object userObject) {
        this(userObject, true);
    }

    public String getKey() {
        return this.key;
    }

    public String toCode() {
        return this.toCode("");
    }

    private String toCode(String prefix) {
        String str = String.valueOf(prefix) + this.getKey() + "\n";
        if (!this.isRoot()) {
            prefix = String.valueOf(prefix) + "\t";
        }
        int idx = 0;
        while (idx < this.getChildCount()) {
            TreeNode child = this.getChildAt(idx);
            if (child instanceof MutableNode) {
                str = String.valueOf(str) + ((MutableNode)child).toCode(prefix);
            }
            ++idx;
        }
        return str;
    }

    public static MutableNode getNodeFromCode(String str) {
        String[] lines = ParsingTools.split(str, "[\\n]");
        MutableNode rootNode = new MutableNode(lines[0], true);
        if (!rootNode.key.startsWith("[")) {
            rootNode.setAllowsChildren(false);
            return rootNode;
        }
        Vector<MutableNode> parents = new Vector<MutableNode>();
        parents.add(0, rootNode);
        int idx = 1;
        while (idx < lines.length) {
            String key = lines[idx];
            int nTab = ParsingTools.countRepsAtBegin(key, "\t");
            key = key.trim();
            MutableNode child = new MutableNode(key);
            ((MutableNode)parents.get(nTab - 1)).add(child);
            if (key.startsWith("[")) {
                parents.add(nTab, child);
            } else {
                child.setAllowsChildren(false);
            }
            ++idx;
        }
        return rootNode;
    }

    public Vector<MutableNode> getAllLeaves() {
        Vector<MutableNode> v = new Vector<MutableNode>();
        this.addLeavesTo(v);
        return v;
    }

    private Vector<MutableNode> addLeavesTo(Vector<MutableNode> v) {
        int idx = 0;
        while (idx < this.getChildCount()) {
            MutableNode node = (MutableNode)this.getChildAt(idx);
            if (node.isLeaf()) {
                v.add(node);
            } else {
                node.addLeavesTo(v);
            }
            ++idx;
        }
        return v;
    }
}

