/*
 * Decompiled with CFR 0.152.
 */
package painter;

import apps.GraphicApplication;
import apps.SysCommandManager;
import exceptions.LowWeightException;
import files.Translator;
import geoTortue.TDrawPane;
import geoTortue.TImagePainter;
import gui.SimpleColorChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;

public final class TurtlePainter
extends GraphicApplication
implements SimpleColorChooser.SimpleColorChooserListener,
TDrawPane.UndoListener {
    private TDrawPane drawPane;
    private SimpleColorChooser colorChooser;

    public TurtlePainter(String cfgDir, TImagePainter smoothImg, TImagePainter rawImg) {
        super("Coloriage", "tpainter", cfgDir);
        this.extension = ".png";
        this.admissibleExtensions = new String[]{".png"};
        this.admissibleExtensions = this.admissibleExtensions;
        this.colorChooser = new SimpleColorChooser(this.frame);
        this.frame.getContentPane().add((Component)this.colorChooser, "East");
        this.drawPane = new TDrawPane(this.frame, smoothImg, rawImg, this.colorChooser);
        JScrollPane scrollPane = new JScrollPane(this.drawPane);
        this.frame.getContentPane().add((Component)scrollPane, "Center");
        this.colorChooser.addListener(this);
        this.drawPane.addListener(this);
        this.setButtonEnabled("undo", false);
        this.setButtonEnabled("redo", false);
        URL url = this.getClass().getResource(String.valueOf(cfgDir) + "icon.gif");
        if (url != null) {
            try {
                this.frame.setIconImage(ImageIO.read(url));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.frame.setVisible(true);
        this.frame.setExtendedState(6);
    }

    public void newFrame() {
    }

    public void load(File file) {
    }

    public boolean save(File file) {
        try {
            ImageIO.write((RenderedImage)this.drawPane.getImage(), "png", file);
            this.drawPane.setModified(false);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    protected boolean hasBeenModified() {
        return this.drawPane.hasBeenModified();
    }

    public String getFileDescription() {
        return "*.png";
    }

    protected void registerNewCommands() {
        super.registerNewCommands();
        SysCommandManager sysCommandManager = this.sysCommandManager;
        sysCommandManager.getClass();
        new SysCommandManager.SysCommand(sysCommandManager, "undo", "edit-undo", 128, 90){

            public void execute(String ... args) throws LowWeightException {
                TurtlePainter.this.drawPane.undo();
            }
        };
        SysCommandManager sysCommandManager2 = this.sysCommandManager;
        sysCommandManager2.getClass();
        new SysCommandManager.SysCommand(sysCommandManager2, "redo", "edit-redo", 128, 89){

            public void execute(String ... args) throws LowWeightException {
                TurtlePainter.this.drawPane.redo();
            }
        };
        SysCommandManager sysCommandManager3 = this.sysCommandManager;
        sysCommandManager3.getClass();
        new SysCommandManager.SysCommand(sysCommandManager3, "revert", "media-seek-backward"){

            public void execute(String ... args) throws LowWeightException {
                int confirm = JOptionPane.showConfirmDialog(TurtlePainter.this.frame, Translator.get("confirm.revert"), Translator.get("confirm"), 0, 3);
                if (confirm == 0) {
                    TurtlePainter.this.drawPane.revertToOriginal();
                }
            }
        };
        SysCommandManager sysCommandManager4 = this.sysCommandManager;
        sysCommandManager4.getClass();
        new SysCommandManager.SysCommand(sysCommandManager4, "flood", "flood", 0, 70){

            public void execute(String ... args) throws LowWeightException {
                TurtlePainter.this.drawPane.setMode(1);
            }
        };
        SysCommandManager sysCommandManager5 = this.sysCommandManager;
        sysCommandManager5.getClass();
        new SysCommandManager.SysCommand(sysCommandManager5, "flood", "flood", 0, 70){

            public void execute(String ... args) throws LowWeightException {
                TurtlePainter.this.drawPane.setMode(1);
            }
        };
        SysCommandManager sysCommandManager6 = this.sysCommandManager;
        sysCommandManager6.getClass();
        new SysCommandManager.SysCommand(sysCommandManager6, "color_picker", "color_picker", 0, 80){

            public void execute(String ... args) throws LowWeightException {
                TurtlePainter.this.drawPane.setMode(2);
            }
        };
    }

    public void newColorSelected(Color c) {
        this.drawPane.setMode(1);
    }

    public void canUndo(boolean b) {
        this.setButtonEnabled("undo", b);
    }

    public void canRedo(boolean b) {
        this.setButtonEnabled("redo", b);
    }
}

