/*
 * Decompiled with CFR 0.152.
 */
package painter;

import geoTortue.TImagePainter;
import java.awt.image.BufferedImage;
import java.util.Stack;

public class ImagePainter
extends BufferedImage {
    public ImagePainter(int width, int height) {
        super(width, height, 1);
    }

    public ImagePainter(BufferedImage img) {
        super(img.getWidth(), img.getHeight(), 1);
        this.copy(img);
    }

    protected void copy(BufferedImage img) {
        int x = 0;
        while (x < this.getWidth()) {
            int y = 0;
            while (y < this.getHeight()) {
                this.setRGB(x, y, img.getRGB(x, y));
                ++y;
            }
            ++x;
        }
    }

    protected boolean areClosed(int c1, int c2, int tolerance) {
        return this.distance(c1, c2) <= tolerance;
    }

    public void floodFill(int i, int j, int newRgb) {
        this.floodFill(i, j, newRgb, 0);
    }

    public void floodFill(int i, int j, int newRgb, int tolerance) {
        int oldRgb = this.getRGB(i, j);
        if (this.areClosed(newRgb, oldRgb, 0)) {
            return;
        }
        Stack<Integer> xStack = new Stack<Integer>();
        Stack<Integer> yStack = new Stack<Integer>();
        int x0 = i;
        int y0 = j;
        xStack.push(x0);
        yStack.push(y0);
        while (!xStack.isEmpty()) {
            int x;
            boolean shouldPushNextValidPixel;
            x0 = (Integer)xStack.pop();
            y0 = (Integer)yStack.pop();
            int west = x0;
            int east = x0;
            while (west > 0 && this.areClosed(this.getRGB(west, y0), oldRgb, tolerance)) {
                --west;
            }
            while (east + 1 < this.getWidth() && this.areClosed(this.getRGB(east, y0), oldRgb, tolerance)) {
                ++east;
            }
            ++west;
            --east;
            if (y0 > 0) {
                shouldPushNextValidPixel = true;
                x = west;
                while (x <= east) {
                    if (this.areClosed(this.getRGB(x, y0 - 1), oldRgb, tolerance)) {
                        if (shouldPushNextValidPixel) {
                            xStack.push(x);
                            yStack.push(y0 - 1);
                            shouldPushNextValidPixel = false;
                        }
                    } else {
                        shouldPushNextValidPixel = true;
                    }
                    ++x;
                }
            }
            if (y0 + 1 < this.getHeight()) {
                shouldPushNextValidPixel = true;
                x = west;
                while (x <= east) {
                    if (this.areClosed(this.getRGB(x, y0 + 1), oldRgb, tolerance)) {
                        if (shouldPushNextValidPixel) {
                            xStack.push(x);
                            yStack.push(y0 + 1);
                            shouldPushNextValidPixel = false;
                        }
                    } else {
                        shouldPushNextValidPixel = true;
                    }
                    ++x;
                }
            }
            int x2 = west;
            while (x2 <= east) {
                this.setRGB(x2, y0, newRgb);
                ++x2;
            }
        }
    }

    public int getRGB(int x, int y) {
        int c = super.getRGB(x, y);
        if (c == -16777216) {
            c = 0;
        }
        return c;
    }

    public void smooth() {
        TImagePainter newImg = new TImagePainter(this.getWidth(), this.getHeight());
        int x = 1;
        while (x < this.getWidth() - 1) {
            int y = 1;
            while (y < this.getHeight() - 1) {
                int c21 = this.getRGB(x - 1, y);
                int c12 = this.getRGB(x, y - 1);
                int c22 = this.getRGB(x, y);
                int c32 = this.getRGB(x, y + 1);
                int c23 = this.getRGB(x + 1, y);
                newImg.setRGB(x, y, this.mean(c22, c22, c22, c22, c22, c23, c12, c21, c32));
                ++y;
            }
            ++x;
        }
        this.copy(newImg);
    }

    protected int distance(int c1, int c2) {
        int r1 = (c1 & 0xFF0000) >> 16;
        int g1 = (c1 & 0xFF00) >> 8;
        int b1 = c1 & 0xFF;
        int r2 = (c2 & 0xFF0000) >> 16;
        int g2 = (c2 & 0xFF00) >> 8;
        int b2 = c2 & 0xFF;
        int dr = Math.abs(r1 - r2);
        int dg = Math.abs(g1 - g2);
        int db = Math.abs(b1 - b2);
        return Math.max(dr, Math.max(dg, db));
    }

    public void multiply(BufferedImage img) {
        if (this.getWidth() != img.getWidth() || this.getHeight() != img.getHeight()) {
            return;
        }
        int x = 0;
        while (x < this.getWidth()) {
            int y = 0;
            while (y < this.getHeight()) {
                this.setRGB(x, y, this.multiply(this.getRGB(x, y), img.getRGB(x, y)));
                ++y;
            }
            ++x;
        }
    }

    protected int multiply(int c1, int c2) {
        int r1 = (c1 & 0xFF0000) >> 16;
        int g1 = (c1 & 0xFF00) >> 8;
        int b1 = c1 & 0xFF;
        int r2 = (c2 & 0xFF0000) >> 16;
        int g2 = (c2 & 0xFF00) >> 8;
        int b2 = c2 & 0xFF;
        int r = this.multiplyComponent(r1, r2);
        int g = this.multiplyComponent(g1, g2);
        int b = this.multiplyComponent(b1, b2);
        return r * 256 * 256 + g * 256 + b;
    }

    protected int multiplyComponent(int a, int b) {
        if (a == b) {
            return a;
        }
        return b * a / 255;
    }

    protected int mean(int ... colors) {
        int r = 0;
        int g = 0;
        int b = 0;
        int[] nArray = colors;
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            int color = nArray[n];
            r += (color & 0xFF0000) >> 16;
            g += (color & 0xFF00) >> 8;
            b += color & 0xFF;
            ++n;
        }
        return (r /= colors.length) * 256 * 256 + (g /= colors.length) * 256 + (b /= colors.length);
    }
}

