/*
 * Decompiled with CFR 0.152.
 */
package jep.function;

import java.util.Stack;
import jep.ParseException;
import jep.function.PostfixMathCommand;
import jep.type.Complex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TanH
extends PostfixMathCommand {
    public TanH() {
        this.numberOfParameters = 1;
    }

    @Override
    public void run(Stack<Object> inStack) throws ParseException {
        this.checkStack(inStack);
        Object param = inStack.pop();
        inStack.push(this.tanh(param));
    }

    public Object tanh(Object param) throws ParseException {
        if (param instanceof Complex) {
            return ((Complex)param).tanh();
        }
        if (param instanceof Number) {
            double value = ((Number)param).doubleValue();
            return new Double((Math.exp(value) - Math.exp(-value)) / (Math.pow(Math.E, value) + Math.pow(Math.E, -value)));
        }
        throw new ParseException("Invalid parameter type");
    }
}

