/*
 * Decompiled with CFR 0.152.
 */
package jep.function;

import java.util.Stack;
import java.util.Vector;
import jep.ParseException;
import jep.function.PostfixMathCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Range
extends PostfixMathCommand {
    public Range() {
        this.numberOfParameters = -1;
    }

    public Object genRange(double low, double inc, int steps) {
        Vector<Double> res = new Vector<Double>(steps);
        res.setSize(steps);
        int i = 0;
        while (i < steps) {
            res.set(i, new Double(low + inc * (double)i));
            ++i;
        }
        return res;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run(Stack<Object> inStack) throws ParseException {
        void var2_17;
        Object res;
        this.checkStack(inStack);
        if (this.curNumberOfParameters < 1) {
            throw new ParseException("Empty list");
        }
        if (this.curNumberOfParameters == 2) {
            Object lastObj = inStack.pop();
            Object firstObj = inStack.pop();
            double last = ((Number)lastObj).doubleValue();
            double first = ((Number)firstObj).doubleValue();
            double diff = last - first;
            int steps = 1 + (int)diff;
            res = this.genRange(first, 1.0, steps);
        } else if (this.curNumberOfParameters == 3) {
            Object incObj = inStack.pop();
            Object lastObj = inStack.pop();
            Object firstObj = inStack.pop();
            double inc = ((Number)incObj).doubleValue();
            double last = ((Number)lastObj).doubleValue();
            double first = ((Number)firstObj).doubleValue();
            double diff = (last - first) / inc;
            int steps = 1 + (int)diff;
            res = this.genRange(first, inc, steps);
        } else if (this.curNumberOfParameters == 4) {
            Object stepsObj = inStack.pop();
            Object lastObj = inStack.pop();
            Object firstObj = inStack.pop();
            int steps = ((Number)stepsObj).intValue();
            double last = ((Number)lastObj).doubleValue();
            double first = ((Number)firstObj).doubleValue();
            double inc = (last - first) / (double)(steps - 1);
            res = this.genRange(first, inc, steps);
        } else {
            throw new ParseException("Range:only a maximum of four arguments can be specified");
        }
        inStack.push(var2_17);
    }
}

