/*
 * Decompiled with CFR 0.152.
 */
package jep.function;

import java.util.Stack;
import java.util.Vector;
import jep.ParseException;
import jep.function.PostfixMathCommand;
import jep.type.Complex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Multiply
extends PostfixMathCommand {
    public Multiply() {
        this.numberOfParameters = -1;
    }

    @Override
    public void run(Stack<Object> stack) throws ParseException {
        this.checkStack(stack);
        Object product = stack.pop();
        int i = 1;
        while (i < this.curNumberOfParameters) {
            Object param = stack.pop();
            product = this.mul(param, product);
            ++i;
        }
        stack.push(product);
    }

    public Object mul(Object param1, Object param2) throws ParseException {
        if (param1 instanceof Complex) {
            if (param2 instanceof Complex) {
                return this.mul((Complex)param1, (Complex)param2);
            }
            if (param2 instanceof Number) {
                return this.mul((Complex)param1, (Number)param2);
            }
            if (param2 instanceof Vector) {
                return this.mul((Vector)param2, (Complex)param1);
            }
        } else if (param1 instanceof Number) {
            if (param2 instanceof Complex) {
                return this.mul((Complex)param2, (Number)param1);
            }
            if (param2 instanceof Number) {
                return this.mul((Number)param1, (Number)param2);
            }
            if (param2 instanceof Vector) {
                return this.mul((Vector)param2, (Number)param1);
            }
        } else if (param1 instanceof Vector) {
            if (param2 instanceof Complex) {
                return this.mul((Vector)param1, (Complex)param2);
            }
            if (param2 instanceof Number) {
                return this.mul((Vector)param1, (Number)param2);
            }
        }
        throw new ParseException("Invalid parameter type");
    }

    public Double mul(Number d1, Number d2) {
        return new Double(d1.doubleValue() * d2.doubleValue());
    }

    public Complex mul(Complex c1, Complex c2) {
        return c1.mul(c2);
    }

    public Complex mul(Complex c, Number d) {
        return c.mul(d.doubleValue());
    }

    public Vector<Double> mul(Vector v, Number d) {
        Vector<Double> result = new Vector<Double>();
        int i = 0;
        while (i < v.size()) {
            result.addElement(this.mul((Number)v.elementAt(i), d));
            ++i;
        }
        return result;
    }

    public Vector<Complex> mul(Vector v, Complex c) {
        Vector<Complex> result = new Vector<Complex>();
        int i = 0;
        while (i < v.size()) {
            result.addElement(this.mul(c, (Number)v.elementAt(i)));
            ++i;
        }
        return result;
    }
}

