/*
 * Decompiled with CFR 0.152.
 */
package jep.function;

import java.util.Stack;
import jep.ParseException;
import jep.function.PostfixMathCommand;
import jep.type.Complex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Logarithm
extends PostfixMathCommand {
    private static final double LOG10 = Math.log(10.0);
    private static final Complex CLOG10 = new Complex(Math.log(10.0), 0.0);

    public Logarithm() {
        this.numberOfParameters = 1;
    }

    @Override
    public void run(Stack<Object> inStack) throws ParseException {
        this.checkStack(inStack);
        Object param = inStack.pop();
        inStack.push(this.log(param));
    }

    public Object log(Object param) throws ParseException {
        if (param instanceof Complex) {
            return ((Complex)param).log().div(CLOG10);
        }
        if (param instanceof Number) {
            double num = ((Number)param).doubleValue();
            if (num >= 0.0) {
                return new Double(Math.log(num) / LOG10);
            }
            if (num != num) {
                return new Double(Double.NaN);
            }
            Complex temp = new Complex(num);
            return temp.log().div(CLOG10);
        }
        throw new ParseException("Invalid parameter type");
    }
}

