/*
 * Decompiled with CFR 0.152.
 */
package jep.function;

import jep.EvaluatorI;
import jep.Node;
import jep.ParseException;
import jep.function.CallbackEvaluationI;
import jep.function.PostfixMathCommand;
import jep.type.Complex;

public class If
extends PostfixMathCommand
implements CallbackEvaluationI {
    public If() {
        this.numberOfParameters = -1;
    }

    public boolean checkNumberOfParameters(int n) {
        return n == 3 || n == 4;
    }

    public Object evaluate(Node node, EvaluatorI pv) throws ParseException {
        double val;
        int num = node.jjtGetNumChildren();
        if (!this.checkNumberOfParameters(num)) {
            throw new ParseException("If operator must have 3 or 4 arguments.");
        }
        Object condVal = pv.eval(node.jjtGetChild(0));
        if (condVal instanceof Boolean) {
            if (((Boolean)condVal).booleanValue()) {
                return pv.eval(node.jjtGetChild(1));
            }
            return pv.eval(node.jjtGetChild(2));
        }
        if (condVal instanceof Complex) {
            val = ((Complex)condVal).re();
        } else if (condVal instanceof Number) {
            val = ((Number)condVal).doubleValue();
        } else {
            throw new ParseException("Condition in if operator must be double or complex");
        }
        if (val > 0.0) {
            return pv.eval(node.jjtGetChild(1));
        }
        if (num == 3 || val < 0.0) {
            return pv.eval(node.jjtGetChild(2));
        }
        return pv.eval(node.jjtGetChild(3));
    }
}

