/*
 * Decompiled with CFR 0.152.
 */
package jep.function;

import java.util.Stack;
import jep.ParseException;
import jep.function.PostfixMathCommand;
import jep.type.Complex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Exp
extends PostfixMathCommand {
    public Exp() {
        this.numberOfParameters = 1;
    }

    @Override
    public void run(Stack<Object> inStack) throws ParseException {
        this.checkStack(inStack);
        Object param = inStack.pop();
        inStack.push(this.exp(param));
    }

    public Object exp(Object param) throws ParseException {
        if (param instanceof Complex) {
            Complex z = (Complex)param;
            double x = z.re();
            double y = z.im();
            double mod = Math.exp(x);
            return new Complex(mod * Math.cos(y), mod * Math.sin(y));
        }
        if (param instanceof Number) {
            return new Double(Math.exp(((Number)param).doubleValue()));
        }
        throw new ParseException("Invalid parameter type");
    }
}

