/*
 * Decompiled with CFR 0.152.
 */
package jep.function;

import java.util.Stack;
import java.util.Vector;
import jep.ASTVarNode;
import jep.EvaluatorI;
import jep.Node;
import jep.ParseException;
import jep.Variable;
import jep.function.LValueI;
import jep.function.PostfixMathCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ele
extends PostfixMathCommand
implements LValueI {
    public Ele() {
        this.numberOfParameters = 2;
    }

    @Override
    public void set(EvaluatorI pv, Node node, Object value) throws ParseException {
        Node lhsNode = node.jjtGetChild(0);
        if (!(lhsNode instanceof ASTVarNode)) {
            throw new ParseException("Ele: lhs must be a variable");
        }
        ASTVarNode vn = (ASTVarNode)lhsNode;
        Variable var = vn.getVar();
        Object rhs = pv.eval(node.jjtGetChild(1));
        int index = -1;
        if (rhs instanceof Number) {
            index = ((Number)rhs).intValue() - 1;
        } else if (rhs instanceof Vector) {
            Vector vec = (Vector)rhs;
            if (vec.size() != 1) {
                throw new ParseException("Ele: only single dimension arrays supported in JEP");
            }
            index = ((Number)vec.firstElement()).intValue() - 1;
        } else {
            throw new ParseException("Ele: rhs must be a number");
        }
        Object oldVarVal = var.getValue();
        if (!(oldVarVal instanceof Vector)) {
            throw new ParseException("Ele: the value of the variable must be a Vector");
        }
        Vector newVarVal = (Vector)oldVarVal;
        newVarVal.set(index, value);
        var.setValue(newVarVal);
    }

    @Override
    public void run(Stack<Object> s) throws ParseException {
        this.checkStack(s);
        Object rhs = s.pop();
        Object lhs = s.pop();
        if (!(lhs instanceof Vector)) {
            throw new ParseException("Ele: lhs must be an instance of Vector");
        }
        if (rhs instanceof Number) {
            int index = ((Number)rhs).intValue();
            Object val = ((Vector)lhs).elementAt(index - 1);
            s.push(val);
            return;
        }
        if (rhs instanceof Vector) {
            Vector vec = (Vector)rhs;
            if (vec.size() != 1) {
                throw new ParseException("Ele: only single dimension arrays supported in JEP");
            }
            int index = ((Number)vec.firstElement()).intValue();
            Object val = ((Vector)lhs).elementAt(index - 1);
            s.push(val);
            return;
        }
        throw new ParseException("Ele: only single dimension arrays supported in JEP");
    }
}

