/*
 * Decompiled with CFR 0.152.
 */
package jep.function;

import java.util.Stack;
import java.util.Vector;
import jep.ParseException;
import jep.function.Add;
import jep.function.Multiply;
import jep.function.PostfixMathCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dot
extends PostfixMathCommand {
    static Add add = new Add();
    static Multiply mul = new Multiply();

    public Dot() {
        this.numberOfParameters = 2;
    }

    @Override
    public void run(Stack<Object> inStack) throws ParseException {
        this.checkStack(inStack);
        Object param2 = inStack.pop();
        Object param1 = inStack.pop();
        inStack.push(this.dot(param1, param2));
    }

    public Object dot(Object param1, Object param2) throws ParseException {
        if (param1 instanceof Vector && param2 instanceof Vector) {
            return this.dot((Vector)param1, (Vector)param2);
        }
        throw new ParseException("Dot: Invalid parameter type, both arguments must be vectors");
    }

    public Object dot(Vector v1, Vector v2) throws ParseException {
        if (v1.size() != v2.size()) {
            throw new ParseException("Dot: both sides of dot must be same length");
        }
        int len = v1.size();
        if (len < 1) {
            throw new ParseException("Dot: empty vectors parsed");
        }
        Object res = mul.mul(v1.elementAt(0), v2.elementAt(0));
        int i = 1;
        while (i < len) {
            res = add.add(res, mul.mul(v1.elementAt(i), v2.elementAt(i)));
            ++i;
        }
        return res;
    }
}

