/*
 * Decompiled with CFR 0.152.
 */
package jep.function;

import java.util.Stack;
import java.util.Vector;
import jep.ParseException;
import jep.function.PostfixMathCommand;
import jep.type.Complex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Divide
extends PostfixMathCommand {
    public Divide() {
        this.numberOfParameters = 2;
    }

    @Override
    public void run(Stack<Object> inStack) throws ParseException {
        this.checkStack(inStack);
        Object param2 = inStack.pop();
        Object param1 = inStack.pop();
        inStack.push(this.div(param1, param2));
    }

    public Object div(Object param1, Object param2) throws ParseException {
        if (param1 instanceof Complex) {
            if (param2 instanceof Complex) {
                return this.div((Complex)param1, (Complex)param2);
            }
            if (param2 instanceof Number) {
                return this.div((Complex)param1, (Number)param2);
            }
            if (param2 instanceof Vector) {
                return this.div((Complex)param1, (Vector)param2);
            }
        } else if (param1 instanceof Number) {
            if (param2 instanceof Complex) {
                return this.div((Number)param1, (Complex)param2);
            }
            if (param2 instanceof Number) {
                return this.div((Number)param1, (Number)param2);
            }
            if (param2 instanceof Vector) {
                return this.div((Number)param1, (Vector)param2);
            }
        } else if (param1 instanceof Vector) {
            if (param2 instanceof Complex) {
                return this.div((Vector)param1, (Complex)param2);
            }
            if (param2 instanceof Number) {
                return this.div((Vector)param1, (Number)param2);
            }
        }
        throw new ParseException("Invalid parameter type");
    }

    public Double div(Number d1, Number d2) {
        return new Double(d1.doubleValue() / d2.doubleValue());
    }

    public Complex div(Complex c1, Complex c2) {
        return c1.div(c2);
    }

    public Complex div(Number d, Complex c) {
        Complex c1 = new Complex(d.doubleValue(), 0.0);
        return c1.div(c);
    }

    public Complex div(Complex c, Number d) {
        return new Complex(c.re() / d.doubleValue(), c.im() / d.doubleValue());
    }

    public Vector<Double> div(Vector v, Number d) {
        Vector<Double> result = new Vector<Double>();
        int i = 0;
        while (i < v.size()) {
            result.addElement(this.div((Number)v.elementAt(i), d));
            ++i;
        }
        return result;
    }

    public Vector<Double> div(Number d, Vector v) {
        Vector<Double> result = new Vector<Double>();
        int i = 0;
        while (i < v.size()) {
            result.addElement(this.div(d, (Number)v.elementAt(i)));
            ++i;
        }
        return result;
    }

    public Vector<Complex> div(Vector v, Complex c) {
        Vector<Complex> result = new Vector<Complex>();
        int i = 0;
        while (i < v.size()) {
            result.addElement(this.div((Number)v.elementAt(i), c));
            ++i;
        }
        return result;
    }

    public Vector<Complex> div(Complex c, Vector v) {
        Vector<Complex> result = new Vector<Complex>();
        int i = 0;
        while (i < v.size()) {
            result.addElement(this.div(c, (Number)v.elementAt(i)));
            ++i;
        }
        return result;
    }
}

