/*
 * Decompiled with CFR 0.152.
 */
package jep.function;

import jep.ASTFunNode;
import jep.ASTVarNode;
import jep.EvaluatorI;
import jep.Node;
import jep.ParseException;
import jep.Variable;
import jep.function.CallbackEvaluationI;
import jep.function.LValueI;
import jep.function.PostfixMathCommand;

public class Assign
extends PostfixMathCommand
implements CallbackEvaluationI {
    public Assign() {
        this.numberOfParameters = 2;
    }

    public Object evaluate(Node node, EvaluatorI pv) throws ParseException {
        if (node.jjtGetNumChildren() != 2) {
            throw new ParseException("Assignment operator must have 2 operators.");
        }
        Object rhsVal = pv.eval(node.jjtGetChild(1));
        Node lhsNode = node.jjtGetChild(0);
        if (lhsNode instanceof ASTVarNode) {
            ASTVarNode vn = (ASTVarNode)lhsNode;
            Variable var = vn.getVar();
            var.setValue(rhsVal);
            return rhsVal;
        }
        if (lhsNode instanceof ASTFunNode && ((ASTFunNode)lhsNode).getPFMC() instanceof LValueI) {
            ((LValueI)((Object)((ASTFunNode)lhsNode).getPFMC())).set(pv, lhsNode, rhsVal);
            return rhsVal;
        }
        throw new ParseException("Assignment should have a variable or LValue for the lhs.");
    }
}

