/*
 * Decompiled with CFR 0.152.
 */
package jep.evaluation;

import java.util.Stack;
import jep.SymbolTable;
import jep.evaluation.CommandElement;
import jep.function.PostfixMathCommandI;

public class CommandEvaluator {
    private CommandElement command;
    private Stack<Object> stack = new Stack();
    private PostfixMathCommandI pfmc;
    private int i;

    public Object evaluate(CommandElement[] commands, SymbolTable symTab) throws Exception {
        int nCommands = commands.length;
        this.stack.removeAllElements();
        this.i = 0;
        while (this.i < nCommands) {
            this.command = commands[this.i];
            switch (this.command.getType()) {
                case 2: {
                    this.pfmc = this.command.getPFMC();
                    this.pfmc.setCurNumberOfParameters(this.command.getNumParam());
                    this.pfmc.run(this.stack);
                    break;
                }
                case 0: {
                    this.stack.push(symTab.getValue(this.command.getVarName()));
                    break;
                }
                default: {
                    this.stack.push(this.command.getValue());
                }
            }
            ++this.i;
        }
        if (this.stack.size() != 1) {
            throw new Exception("CommandEvaluator.evaluate(): Stack size is not 1");
        }
        return this.stack.pop();
    }
}

