/*
 * Decompiled with CFR 0.152.
 */
package jep;

import java.util.Stack;
import jep.ASTConstant;
import jep.ASTFunNode;
import jep.ASTStart;
import jep.ASTVarNode;
import jep.EvaluatorI;
import jep.Node;
import jep.ParseException;
import jep.ParserVisitor;
import jep.SimpleNode;
import jep.SymbolTable;
import jep.Variable;
import jep.function.CallbackEvaluationI;
import jep.function.PostfixMathCommandI;
import jep.function.SpecialEvaluationI;

public class EvaluatorVisitor
implements ParserVisitor,
EvaluatorI {
    protected Stack<Object> stack = new Stack();
    protected SymbolTable symTab = null;
    protected static final boolean debug = false;
    protected boolean trapNullValues = true;

    public Object getValue(Node topNode, SymbolTable symTab_in) throws ParseException {
        if (topNode == null) {
            throw new ParseException("topNode parameter is null");
        }
        this.symTab = symTab_in;
        this.stack.removeAllElements();
        topNode.jjtAccept(this, null);
        if (this.stack.size() != 1) {
            throw new ParseException("Stack corrupted");
        }
        return this.stack.pop();
    }

    public Object eval(Node node) throws ParseException {
        node.jjtAccept(this, null);
        return this.stack.pop();
    }

    public Object eval(PostfixMathCommandI pfmc, Node[] children) throws ParseException {
        if (pfmc instanceof SpecialEvaluationI) {
            ASTFunNode node = new ASTFunNode(2);
            node.setFunction("TmpFun", pfmc);
            node.jjtOpen();
            int i = 0;
            while (i < children.length) {
                node.jjtAddChild(children[i], i);
                ++i;
            }
            node.jjtClose();
            return ((SpecialEvaluationI)((Object)pfmc)).evaluate(node, null, this, new Stack<Object>(), this.symTab);
        }
        if (pfmc instanceof CallbackEvaluationI) {
            ASTFunNode node = new ASTFunNode(2);
            node.setFunction("TmpFun", pfmc);
            node.jjtOpen();
            int i = 0;
            while (i < children.length) {
                node.jjtAddChild(children[i], i);
                ++i;
            }
            node.jjtClose();
            Object val = ((CallbackEvaluationI)((Object)pfmc)).evaluate(node, this);
            return val;
        }
        Stack<Object> lstack = new Stack<Object>();
        int i = 0;
        while (i < children.length) {
            if (!(children[i] instanceof ASTConstant)) {
                throw new ParseException("buildConstantNode: arguments must all be constant nodes");
            }
            lstack.push(((ASTConstant)children[i]).getValue());
            ++i;
        }
        pfmc.setCurNumberOfParameters(children.length);
        pfmc.run(lstack);
        return lstack.pop();
    }

    public Object visit(SimpleNode node, Object data) throws ParseException {
        throw new ParseException("No visit method for " + node.getClass().getName());
    }

    public Object visit(ASTStart node, Object data) throws ParseException {
        throw new ParseException("Start node encountered during evaluation");
    }

    public Object visit(ASTFunNode node, Object data) throws ParseException {
        if (node == null) {
            return null;
        }
        PostfixMathCommandI pfmc = node.getPFMC();
        if (pfmc == null) {
            throw new ParseException("No function class associated with " + node.getName());
        }
        if (pfmc instanceof SpecialEvaluationI) {
            return ((SpecialEvaluationI)((Object)pfmc)).evaluate(node, data, this, this.stack, this.symTab);
        }
        if (pfmc instanceof CallbackEvaluationI) {
            Object val = ((CallbackEvaluationI)((Object)pfmc)).evaluate(node, this);
            this.stack.push(val);
            return val;
        }
        data = node.childrenAccept(this, data);
        if (pfmc.getNumberOfParameters() == -1) {
            pfmc.setCurNumberOfParameters(node.jjtGetNumChildren());
        }
        pfmc.run(this.stack);
        return data;
    }

    public Object visit(ASTVarNode node, Object data) throws ParseException {
        Variable var = node.getVar();
        if (var == null) {
            String message = "Could not evaluate " + node.getName() + ": ";
            throw new ParseException(String.valueOf(message) + "the variable was not found in the symbol table");
        }
        Object temp = var.getValue();
        if (this.trapNullValues && temp == null) {
            String message = "Could not evaluate " + node.getName() + ": ";
            throw new ParseException(String.valueOf(message) + "variable not set");
        }
        this.stack.push(temp);
        return data;
    }

    public Object visit(ASTConstant node, Object data) {
        this.stack.push(node.getValue());
        return data;
    }

    public boolean isTrapNullValues() {
        return this.trapNullValues;
    }

    public void setTrapNullValues(boolean b) {
        this.trapNullValues = b;
    }
}

