/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JPanel;

public class VerticalPanel
extends JPanel {
    private static final long serialVersionUID = 984555792492967914L;

    public VerticalPanel(int vgap, Component ... components) {
        super(new Layout(vgap));
        Component[] componentArray = components;
        int n = 0;
        int n2 = componentArray.length;
        while (n < n2) {
            Component c = componentArray[n];
            this.add(c);
            ++n;
        }
    }

    public VerticalPanel(Component ... components) {
        this(10, components);
    }

    static class Layout
    implements LayoutManager {
        int vgap;

        Layout(int vgap) {
            this.vgap = vgap;
        }

        public void layoutContainer(Container parent) {
            Insets insets = parent.getInsets();
            int currY = insets.top;
            Component[] components = parent.getComponents();
            int cellW = parent.getWidth() - insets.left - insets.right;
            int idx = 0;
            while (idx < components.length) {
                Component c = components[idx];
                int cellH = c.getPreferredSize().height;
                c.setBounds(insets.left, currY, cellW, cellH);
                currY += cellH + this.vgap;
                ++idx;
            }
        }

        public Dimension preferredLayoutSize(Container parent) {
            return this.minimumLayoutSize(parent);
        }

        public Dimension minimumLayoutSize(Container parent) {
            Component[] components = parent.getComponents();
            int height = parent.getInsets().top;
            int idx = 0;
            while (idx < components.length) {
                Component c = components[idx];
                int cellH = c.getPreferredSize().height;
                height += cellH + this.vgap;
                ++idx;
            }
            return new Dimension(parent.getWidth(), height);
        }

        public void addLayoutComponent(String arg0, Component arg1) {
        }

        public void removeLayoutComponent(Component arg0) {
        }
    }
}

