/*
 * Decompiled with CFR 0.152.
 */
package gui;

import files.Translator;
import gui.FixGridLayout;
import gui.SFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EventListener;
import javax.swing.BorderFactory;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;

public class SimpleColorChooser
extends JPanel {
    private static final long serialVersionUID = 1153939479672185781L;
    SFrame owner;
    private int cellSize = 20;
    private final EventListenerList listeners = new EventListenerList();
    private ColorCase headerCase;
    private final Color pseudoBlack;
    private Color currentColor = this.pseudoBlack = new Color(1, 1, 1);

    public SimpleColorChooser(SFrame fr) {
        this.owner = fr;
        JPanel pane = new JPanel();
        pane.setLayout(new FixGridLayout(2, 14, 2, 2, this.cellSize, this.cellSize));
        pane.setBorder(BorderFactory.createEtchedBorder(0));
        pane.add(new ColorCase(1, 1, 1));
        pane.add(new ColorCase(255, 255, 255));
        pane.add(new ColorCase(189, 189, 189));
        pane.add(new ColorCase(123, 123, 123));
        pane.add(new ColorCase(255, 0, 0));
        pane.add(new ColorCase(123, 0, 0));
        pane.add(new ColorCase(255, 255, 0));
        pane.add(new ColorCase(123, 123, 0));
        pane.add(new ColorCase(0, 255, 0));
        pane.add(new ColorCase(0, 123, 0));
        pane.add(new ColorCase(0, 255, 255));
        pane.add(new ColorCase(0, 123, 123));
        pane.add(new ColorCase(0, 0, 255));
        pane.add(new ColorCase(0, 0, 123));
        pane.add(new ColorCase(255, 0, 255));
        pane.add(new ColorCase(123, 0, 123));
        pane.add(new ColorCase(255, 255, 123));
        pane.add(new ColorCase(123, 123, 57));
        pane.add(new ColorCase(0, 255, 123));
        pane.add(new ColorCase(0, 57, 57));
        pane.add(new ColorCase(123, 255, 255));
        pane.add(new ColorCase(0, 123, 255));
        pane.add(new ColorCase(123, 123, 255));
        pane.add(new ColorCase(0, 57, 123));
        pane.add(new ColorCase(255, 0, 123));
        pane.add(new ColorCase(57, 0, 255));
        pane.add(new ColorCase(255, 123, 57));
        pane.add(new ColorCase(123, 57, 0));
        JPanel head = new JPanel();
        head.setLayout(new FixGridLayout(1, 1, 2, 10, 2 * this.cellSize + 1, 2 * this.cellSize + 1));
        this.headerCase = new ColorCase(0, 0, 0);
        head.add(this.headerCase);
        this.headerCase.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                Color c = JColorChooser.showDialog(SimpleColorChooser.this.getTopLevelAncestor(), Translator.get("choose_color"), SimpleColorChooser.this.headerCase.color);
                if (c == null) {
                    return;
                }
                if (c.getRed() == 0 & c.getGreen() == 0 && c.getBlue() == 0) {
                    c = SimpleColorChooser.this.pseudoBlack;
                }
                SimpleColorChooser.this.setColor(c);
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)pane, "Center");
        this.add((Component)head, "North");
    }

    public void setColor(Color c) {
        this.currentColor = c;
        this.headerCase.color = c;
        this.headerCase.repaint();
    }

    public Color getCurrentColor() {
        return this.currentColor;
    }

    public void addListener(SimpleColorChooserListener listener) {
        this.listeners.add(SimpleColorChooserListener.class, listener);
    }

    public void removeListener(SimpleColorChooserListener listener) {
        this.listeners.remove(SimpleColorChooserListener.class, listener);
    }

    public SimpleColorChooserListener[] getColorListeners() {
        return (SimpleColorChooserListener[])this.listeners.getListeners(SimpleColorChooserListener.class);
    }

    protected synchronized void fireNewColorSelected(Color color) {
        SimpleColorChooserListener[] table = this.getColorListeners();
        int idx = 0;
        while (idx < table.length) {
            table[idx].newColorSelected(color);
            ++idx;
        }
    }

    private class ColorCase
    extends JPanel
    implements MouseListener {
        private static final long serialVersionUID = 1L;
        private Color color;

        ColorCase(int r, int g, int b) {
            this.color = new Color(r, g, b);
            this.setBorder(BorderFactory.createEtchedBorder(0));
            this.addMouseListener(this);
        }

        protected void paintComponent(Graphics g) {
            g.setColor(this.color);
            g.fillRect(2, 2, 2 * SimpleColorChooser.this.cellSize, 2 * SimpleColorChooser.this.cellSize);
        }

        public void mouseClicked(MouseEvent arg0) {
            SimpleColorChooser.this.setColor(this.color);
            SimpleColorChooser.this.fireNewColorSelected(this.color);
        }

        public void mousePressed(MouseEvent arg0) {
        }

        public void mouseReleased(MouseEvent arg0) {
        }

        public void mouseEntered(MouseEvent arg0) {
            SimpleColorChooser.this.owner.setCursor("hand");
        }

        public void mouseExited(MouseEvent arg0) {
            SimpleColorChooser.this.owner.setDefaultCursor();
        }
    }

    public static interface SimpleColorChooserListener
    extends EventListener {
        public void newColorSelected(Color var1);
    }
}

