/*
 * Decompiled with CFR 0.152.
 */
package gui;

import apps.AbstractApplication;
import apps.AbstractSysCommand;
import apps.SysCommandManager;
import exceptions.LowWeightException;
import exceptions.NoSuchCommandException;
import files.BasicFile;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JToolBar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SToolBar
extends JToolBar
implements ActionListener {
    private static final long serialVersionUID = -3207967723479679397L;
    protected SysCommandManager scm;

    public SToolBar(AbstractApplication app, URL url, int orientation, boolean b) {
        super(orientation);
        this.scm = app.getSysCommandManager();
        this.setFloatable(b);
        this.setBackground(new Color(240, 240, 240));
        try {
            BasicFile file = new BasicFile(url);
            for (String line : file.getLines()) {
                this.addButton(line);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void addButton(String key) {
        if (key.equals("<sep>")) {
            this.add(new JToolBar.Separator());
        } else {
            JButton button = new JButton();
            button.setActionCommand(key);
            try {
                AbstractSysCommand command = this.scm.getCommand(key);
                button.setIcon(command.getIcon());
                button.setToolTipText(command.getToolTipText());
                button.setMargin(new Insets(0, 0, 0, 0));
                button.addActionListener(this);
                button.setFocusable(false);
                button.setBackground(new Color(240, 240, 240));
                this.add(button);
            }
            catch (NoSuchCommandException ex) {
                System.out.println("Commande " + key + " non d\u00e9finie !");
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String key = ((JButton)e.getSource()).getActionCommand();
        try {
            this.scm.processCommand(key);
        }
        catch (NoSuchCommandException ex) {
            ex.printStackTrace();
        }
        catch (LowWeightException ex) {
            ex.printStackTrace();
        }
    }

    public Vector<JButton> getButtons() {
        Vector<JButton> v = new Vector<JButton>();
        Component[] componentArray = this.getComponents();
        int n = 0;
        int n2 = componentArray.length;
        while (n < n2) {
            Component c = componentArray[n];
            if (c instanceof JButton) {
                v.add((JButton)c);
            }
            ++n;
        }
        return v;
    }
}

