/*
 * Decompiled with CFR 0.152.
 */
package gui;

import apps.AbstractSysCommand;
import apps.SysCommandManager;
import exceptions.LowWeightException;
import exceptions.NoSuchCommandException;
import files.Translator;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.regex.Pattern;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.tree.TreeNode;
import trees.MutableNode;

public class SMenu
extends JMenu
implements ActionListener {
    private static final long serialVersionUID = 8056685234084478127L;
    private SysCommandManager sysCommandManager;

    public SMenu(SysCommandManager scm, String key) {
        super(Translator.get(key));
        this.sysCommandManager = scm;
    }

    public void actionPerformed(ActionEvent e) {
        String key = ((JMenuItem)e.getSource()).getActionCommand();
        try {
            this.sysCommandManager.processCommand(key);
        }
        catch (NoSuchCommandException ex) {
            ex.printStackTrace();
        }
        catch (LowWeightException ex) {
            ex.printStackTrace();
        }
    }

    private JMenuItem makeMenuItem(String key) {
        try {
            AbstractSysCommand command = this.sysCommandManager.getCommand(key);
            JMenuItem item = new JMenuItem(command.getText());
            item.setActionCommand(key);
            item.addActionListener(this);
            item.setIcon(command.getIcon());
            item.setAccelerator(command.getKeyStroke());
            this.add(item);
            return item;
        }
        catch (NoSuchCommandException e) {
            System.out.println("Commande " + key + " non d\u00e9finie !");
            return new JMenuItem();
        }
    }

    public class Node
    extends MutableNode {
        private static final long serialVersionUID = -3904241206911216350L;
        private char mnemonic;
        private String SEP;

        public Node(String str) {
            super(str, true);
            this.SEP = "<sep>";
            String[] words = Pattern.compile("[:]").split(str);
            String key = words[0];
            if (key.startsWith("[")) {
                this.key = "[" + key.substring(1, key.length() - 1).trim() + "]";
                this.setUserObject(new SMenu(SMenu.this.sysCommandManager, this.key));
            } else {
                this.key = str.trim();
                this.setAllowsChildren(false);
                if (key.equals(this.SEP)) {
                    this.setUserObject(new JSeparator());
                } else {
                    this.setUserObject(SMenu.this.makeMenuItem(key));
                }
            }
            if (words.length > 1) {
                String mnemo = words[1];
                this.mnemonic = mnemo.substring(0, mnemo.length() - 1).trim().charAt(0);
            }
        }

        public Node(MutableNode node) {
            this(node.getKey());
            if (node.getAllowsChildren()) {
                SMenu menu = (SMenu)this.getUserObject();
                menu.setMnemonic(this.getMnemonic());
                Enumeration<TreeNode> e = node.children();
                while (e.hasMoreElements()) {
                    Node child = sMenu.new Node((MutableNode)e.nextElement());
                    this.add(child);
                    menu.add((Component)child.getUserObject());
                }
            }
        }

        public char getMnemonic() {
            return this.mnemonic;
        }
    }
}

