/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class KVPanel
extends JPanel {
    private static final long serialVersionUID = 1915953672413259508L;

    public KVPanel(String title, int nx, int ny, Component ... components) {
        super(new Layout(ny, nx));
        Component[] componentArray = components;
        int n = 0;
        int n2 = componentArray.length;
        while (n < n2) {
            Component c = componentArray[n];
            this.add(c);
            ++n;
        }
        this.setBorder(BorderFactory.createTitledBorder(title));
    }

    public KVPanel(String title, Component ... components) {
        this(title, 10, 10, components);
    }

    static class Layout
    implements LayoutManager {
        private int hgap;
        private int vgap;
        private int leftCellW;
        private int rightCellW;

        Layout(int hgap, int vgap) {
            this.hgap = hgap;
            this.vgap = vgap;
            this.leftCellW = 20;
            this.rightCellW = 20;
        }

        public void layoutContainer(Container parent) {
            Insets insets = parent.getInsets();
            int x0 = insets.left;
            int currY = insets.top + this.vgap;
            int margin = (parent.getWidth() - this.hgap - this.leftCellW - this.rightCellW) / 2;
            if (margin > 0) {
                x0 += margin;
            }
            Component[] components = parent.getComponents();
            this.computeCellWidths(components);
            int idx = 0;
            while (idx < components.length) {
                Component leftComponent = components[idx];
                Component rightComponent = components[idx + 1];
                int leftCellH = leftComponent.getPreferredSize().height;
                int rightCellH = rightComponent.getPreferredSize().height;
                int cellH = Math.max(leftCellH, rightCellH);
                leftComponent.setBounds(x0, currY, this.leftCellW, cellH);
                rightComponent.setBounds(x0 + this.hgap + this.leftCellW, currY, this.rightCellW, cellH);
                currY += cellH + this.vgap;
                ++idx;
                ++idx;
            }
        }

        public Dimension preferredLayoutSize(Container parent) {
            return this.minimumLayoutSize(parent);
        }

        public Dimension minimumLayoutSize(Container parent) {
            Component[] components = parent.getComponents();
            int height = parent.getInsets().top + this.vgap;
            int idx = 0;
            while (idx < components.length) {
                Component leftComponent = components[idx];
                Component rightComponent = components[idx + 1];
                int leftCellH = leftComponent.getPreferredSize().height;
                int rightCellH = rightComponent.getPreferredSize().height;
                int cellH = Math.max(leftCellH, rightCellH);
                height += cellH + this.vgap;
                ++idx;
                ++idx;
            }
            this.computeCellWidths(components);
            return new Dimension(this.hgap + this.leftCellW + this.rightCellW, height += this.vgap);
        }

        public void addLayoutComponent(String arg0, Component arg1) {
        }

        public void removeLayoutComponent(Component arg0) {
        }

        private void computeCellWidths(Component[] components) {
            this.leftCellW = 20;
            this.rightCellW = 20;
            int idx = 0;
            while (idx < components.length) {
                Component leftComponent = components[idx];
                Component rightComponent = components[idx + 1];
                this.leftCellW = Math.max(this.leftCellW, leftComponent.getPreferredSize().width);
                this.rightCellW = Math.max(this.rightCellW, rightComponent.getPreferredSize().width);
                ++idx;
                ++idx;
            }
        }
    }
}

