/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JMenuBar;
import javax.swing.JToolBar;

public class HeaderLayout
implements LayoutManager {
    int menuBarHeight;
    int toolBarHeight;

    public HeaderLayout(int menuBarH, int toolBarH) {
        this.menuBarHeight = menuBarH;
        this.toolBarHeight = toolBarH;
    }

    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        int x0 = insets.left;
        int y0 = insets.top;
        int cellH = 0;
        int cellW = parent.getWidth() - x0 - insets.right;
        int currY = y0;
        Component[] componentArray = parent.getComponents();
        int n = 0;
        int n2 = componentArray.length;
        while (n < n2) {
            Component c = componentArray[n];
            if (c instanceof JMenuBar) {
                cellH = this.menuBarHeight;
            }
            if (c instanceof JToolBar) {
                cellH = this.toolBarHeight + 1;
            }
            c.setBounds(x0, currY, cellW, cellH);
            currY += cellH;
            ++n;
        }
    }

    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension(1, 1);
    }

    public Dimension preferredLayoutSize(Container parent) {
        Insets insets = parent.getInsets();
        int x0 = insets.left;
        int y0 = insets.top;
        int height = 0;
        int width = 0;
        Component[] componentArray = parent.getComponents();
        int n = 0;
        int n2 = componentArray.length;
        while (n < n2) {
            Component c = componentArray[n];
            if (c instanceof JMenuBar) {
                height += this.menuBarHeight;
            }
            if (c instanceof JToolBar) {
                height += this.toolBarHeight;
            }
            width = Math.max(width, c.getPreferredSize().width);
            ++n;
        }
        return new Dimension(x0 + width, y0 + height);
    }

    public void addLayoutComponent(String where, Component component) {
    }

    public void removeLayoutComponent(Component arg0) {
    }
}

