/*
 * Decompiled with CFR 0.152.
 */
package gui;

import files.Translator;
import gui.CursorFactory;
import gui.IconFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Stack;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;

public class HTMLFrame
extends JFrame
implements HyperlinkListener,
MouseListener {
    private static final long serialVersionUID = 3967530318852156201L;
    private CursorFactory cursorFactory = new CursorFactory();
    JEditorPane htmlPane = new JEditorPane();
    protected Stack<URL> previousURL = new Stack();
    protected Stack<URL> nextURL = new Stack();
    protected IconFactory iconFactory = new IconFactory();
    Icon goHomeIcon = this.iconFactory.get("go-home");
    Icon goPreviousIcon = this.iconFactory.get("go-previous");
    Icon goNextIcon = this.iconFactory.get("go-next");
    public final URL homeURL;
    private AbstractAction goPreviousAction = new AbstractAction(){
        private static final long serialVersionUID = -3966348818259443628L;

        public void actionPerformed(ActionEvent e) {
            if (HTMLFrame.this.previousURL.size() > 1) {
                HTMLFrame.this.nextURL.add(HTMLFrame.this.previousURL.pop());
                HTMLFrame.this.setPage(HTMLFrame.this.previousURL.pop());
            }
        }
    };
    private AbstractAction goNextAction = new AbstractAction(){
        private static final long serialVersionUID = -3966348818259443628L;

        public void actionPerformed(ActionEvent e) {
            if (!HTMLFrame.this.nextURL.isEmpty()) {
                HTMLFrame.this.setPage(HTMLFrame.this.nextURL.pop());
            }
        }
    };
    private AbstractAction goHomeAction = new AbstractAction(){
        private static final long serialVersionUID = -3966348818259443628L;

        public void actionPerformed(ActionEvent e) {
            HTMLFrame.this.nextURL.clear();
            HTMLFrame.this.setPage(HTMLFrame.this.homeURL);
        }
    };
    private KeyAdapter keyAdapter = new KeyAdapter(){

        public void keyTyped(KeyEvent e) {
            if (e.getKeyChar() == '\u001b') {
                HTMLFrame.this.dispose();
            }
        }
    };

    public HTMLFrame(URL url) {
        this.homeURL = url;
        this.htmlPane.setEditable(false);
        this.htmlPane.addHyperlinkListener(this);
        this.setPage(url);
        JToolBar toolBar = new JToolBar();
        JButton goHomeButton = new JButton(this.goHomeAction);
        goHomeButton.setIcon(this.goHomeIcon);
        goHomeButton.setToolTipText(Translator.get("go-home.toolTipText"));
        JButton goPreviousButton = new JButton(this.goPreviousAction);
        goPreviousButton.setIcon(this.goPreviousIcon);
        goPreviousButton.setToolTipText(Translator.get("go-previous.toolTipText"));
        JButton goNextButton = new JButton(this.goNextAction);
        goNextButton.setIcon(this.goNextIcon);
        goNextButton.setToolTipText(Translator.get("go-next.toolTipText"));
        toolBar.add(goHomeButton);
        toolBar.add(goPreviousButton);
        toolBar.add(goNextButton);
        this.htmlPane.addKeyListener(this.keyAdapter);
        goHomeButton.addKeyListener(this.keyAdapter);
        goPreviousButton.addKeyListener(this.keyAdapter);
        goNextButton.addKeyListener(this.keyAdapter);
        this.htmlPane.addMouseListener(this);
        JScrollPane scrollPane = new JScrollPane(this.htmlPane);
        this.getContentPane().add((Component)scrollPane, "Center");
        this.getContentPane().add((Component)toolBar, "North");
        this.validate();
        Dimension d = new Dimension(700, 600);
        scrollPane.setPreferredSize(d);
        this.setPreferredSize(d);
        this.setSize(this.getPreferredSize());
        this.setLocationRelativeTo(null);
        URL logoUrl = this.getClass().getResource("/cfg/icon.gif");
        if (logoUrl != null) {
            try {
                this.setIconImage(ImageIO.read(logoUrl));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.setVisible(true);
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ENTERED) {
            this.setCursor(this.cursorFactory.get("hand"));
        } else if (e.getEventType() == HyperlinkEvent.EventType.EXITED) {
            this.setCursor(this.cursorFactory.get("default"));
        } else if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.nextURL.clear();
            this.setPage(e.getURL());
        }
    }

    private synchronized void setPage(URL url) {
        block8: {
            if (this.htmlPane.getPage() == null || !this.htmlPane.getPage().sameFile(url)) {
                this.previousURL.add(url);
            }
            try {
                try {
                    this.htmlPane.setPage(url);
                }
                catch (IOException e) {
                    if (e instanceof FileNotFoundException) {
                        Document doc = this.htmlPane.getEditorKit().createDefaultDocument();
                        try {
                            doc.insertString(0, "La page n'a pas \u00e9t\u00e9 trouv\u00e9e \u00e0 l'adresse :\n\t" + url, null);
                            this.htmlPane.setDocument(doc);
                        }
                        catch (BadLocationException badLocationException) {}
                        break block8;
                    }
                    e.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                this.goPreviousAction.setEnabled(this.previousURL.size() > 1);
                this.goNextAction.setEnabled(!this.nextURL.isEmpty());
                throw throwable;
            }
        }
        this.goPreviousAction.setEnabled(this.previousURL.size() > 1);
        this.goNextAction.setEnabled(!this.nextURL.isEmpty());
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 3) {
            JPopupMenu popup = new JPopupMenu();
            JMenuItem goHome = new JMenuItem(this.goHomeAction);
            JMenuItem goPrevious = new JMenuItem(this.goPreviousAction);
            JMenuItem goNext = new JMenuItem(this.goNextAction);
            JMenuItem copy = new JMenuItem(new DefaultEditorKit.CopyAction());
            if (this.htmlPane.getSelectedText() == null) {
                copy.setEnabled(false);
            }
            goHome.setIcon(this.goHomeIcon);
            goPrevious.setIcon(this.goPreviousIcon);
            goNext.setIcon(this.goNextIcon);
            copy.setIcon(this.iconFactory.get("copy"));
            goHome.setText(Translator.get("go-home"));
            goPrevious.setText(Translator.get("go-previous"));
            goNext.setText(Translator.get("go-next"));
            copy.setText(Translator.get("copy"));
            popup.add(copy);
            popup.add(new JSeparator());
            popup.add(goPrevious);
            popup.add(goNext);
            popup.add(new JSeparator());
            popup.add(goHome);
            popup.show(this, e.getX(), e.getY());
        }
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }
}

