/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class FixGridLayout
implements LayoutManager {
    private int nx;
    private int ny;
    private int hgap;
    private int vgap;
    private int cellW;
    private int cellH;

    public FixGridLayout(int nx, int ny, int hgap, int vgap, int cellW, int cellH) {
        this.nx = nx;
        this.ny = ny;
        this.hgap = hgap;
        this.vgap = vgap;
        this.cellW = cellW;
        this.cellH = cellH;
    }

    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        int x0 = 1 + this.hgap / 2;
        int y0 = insets.top;
        int idx = 0;
        Component[] componentArray = parent.getComponents();
        int n = 0;
        int n2 = componentArray.length;
        while (n < n2) {
            Component c = componentArray[n];
            int currX = this.hgap + x0 + idx % this.nx * (this.cellW + this.hgap);
            int currY = this.vgap + y0 + idx / this.nx * (this.cellH + this.vgap);
            c.setBounds(currX, currY, this.cellW, this.cellH);
            ++idx;
            ++n;
        }
    }

    public Dimension preferredLayoutSize(Container arg0) {
        return this.minimumLayoutSize(arg0);
    }

    public Dimension minimumLayoutSize(Container arg0) {
        int x = 2 * this.hgap + this.nx * (this.cellW + this.hgap) + 1;
        int y = 2 * this.vgap + this.ny * (this.cellH + this.vgap);
        return new Dimension(x, y);
    }

    public void addLayoutComponent(String arg0, Component arg1) {
    }

    public void removeLayoutComponent(Component arg0) {
    }
}

