/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class DecoratedPane
extends JPanel {
    private static final long serialVersionUID = -1110858498903132629L;
    public static final Color borderColor = new Color(184, 207, 229);
    private String title;
    int buttonSize;
    int headHeight;
    JButton button;

    public DecoratedPane(JComponent c, String title, int headHeight, int buttonSize, Action action, String toolTipText) {
        this.headHeight = headHeight;
        this.buttonSize = buttonSize;
        this.setLayout(new MainLayout(headHeight));
        this.title = title;
        this.button = new JButton(action);
        this.button.setFocusable(false);
        this.button.setToolTipText(toolTipText);
        HeadPanel head = new HeadPanel();
        JPanel componentPane = new JPanel(new GridLayout(1, 1));
        componentPane.add(c);
        this.add(head);
        this.add(componentPane);
    }

    public DecoratedPane(JComponent c, String title, Action a, String toolTipText) {
        this(c, title, 20, 12, a, toolTipText);
    }

    public DecoratedPane(JComponent c, String title) {
        this(c, title, 20, 0, null, "");
    }

    public class HeadPanel
    extends JPanel {
        private static final long serialVersionUID = -2357897772913491486L;

        public HeadPanel() {
            this.setLayout(new HeadPanelLayout());
            this.add(DecoratedPane.this.button);
            this.setBackground(Color.WHITE);
        }

        public void paint(Graphics g) {
            super.paint(g);
            int w = this.getWidth();
            g.setColor(Color.BLACK);
            g.drawString(DecoratedPane.this.title, 6, DecoratedPane.this.headHeight / 2 + 5);
            g.setColor(borderColor);
            g.drawLine(DecoratedPane.this.title.length() * 7 + 20, DecoratedPane.this.headHeight / 2, w - 2 * DecoratedPane.this.buttonSize - 20, DecoratedPane.this.headHeight / 2);
            g.setColor(Color.GRAY);
            g.drawRect(0, 0, w - 2, DecoratedPane.this.headHeight);
        }
    }

    private class MainLayout
    implements LayoutManager {
        int headHeight;

        public MainLayout(int headHeight) {
            this.headHeight = headHeight;
        }

        public void layoutContainer(Container parent) {
            int w = parent.getSize().width;
            int h = parent.getSize().height;
            Component[] components = parent.getComponents();
            try {
                JPanel head = (JPanel)components[0];
                JComponent c = (JComponent)components[1];
                head.setBounds(0, 0, w, this.headHeight);
                c.setBounds(0, this.headHeight, w, h - this.headHeight);
            }
            catch (IndexOutOfBoundsException e) {
                e.printStackTrace();
            }
        }

        public Dimension preferredLayoutSize(Container parent) {
            return this.minimumLayoutSize(parent);
        }

        public Dimension minimumLayoutSize(Container parent) {
            return new Dimension(0, this.headHeight);
        }

        public void addLayoutComponent(String arg0, Component arg1) {
        }

        public void removeLayoutComponent(Component arg0) {
        }
    }

    private class HeadPanelLayout
    implements LayoutManager {
        public void layoutContainer(Container parent) {
            int w = parent.getSize().width;
            int h = parent.getSize().height;
            Component[] components = parent.getComponents();
            try {
                JButton b = (JButton)components[0];
                b.setBounds(w - DecoratedPane.this.buttonSize - (h - DecoratedPane.this.buttonSize) / 2 - 2, (h - DecoratedPane.this.buttonSize) / 2, DecoratedPane.this.buttonSize, DecoratedPane.this.buttonSize);
            }
            catch (IndexOutOfBoundsException e) {
                e.printStackTrace();
            }
        }

        public Dimension preferredLayoutSize(Container parent) {
            return this.minimumLayoutSize(parent);
        }

        public Dimension minimumLayoutSize(Container parent) {
            return new Dimension(DecoratedPane.this.buttonSize, DecoratedPane.this.buttonSize);
        }

        public void addLayoutComponent(String arg0, Component arg1) {
        }

        public void removeLayoutComponent(Component arg0) {
        }
    }

    public static interface ButtonListener {
        public void buttonPushed();
    }
}

