/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.net.URL;
import java.util.Hashtable;

public class CursorFactory {
    private static Toolkit toolkit = Toolkit.getDefaultToolkit();
    public static String directory;
    private final Hashtable<String, Cursor> table = new Hashtable();

    public CursorFactory() {
        this.table.put("default", new Cursor(0));
        this.table.put("hand", new Cursor(12));
    }

    public Cursor get(String key) {
        if (this.table.get(key) == null) {
            System.out.println("Cursor '" + key + "' not found in the table !");
            return this.table.get("default");
        }
        return this.table.get(key);
    }

    public void addCursor(String name, int x, int y) {
        this.table.put(name, this.createCursor(name, x, y));
    }

    public void addCursor(String name) {
        this.table.put(name, this.createCursor(name, 0, 0));
    }

    private Cursor createCursor(String name, int x, int y) {
        URL url = this.getClass().getResource(String.valueOf(directory) + name + ".gif");
        if (url != null) {
            return toolkit.createCustomCursor(toolkit.getImage(url), new Point(x, y), name);
        }
        return null;
    }
}

