/*
 * Decompiled with CFR 0.152.
 */
package gui;

import files.Translator;
import gui.ColorListener;
import gui.CursorFactory;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;

public class ColorChooser
extends JPanel
implements MouseListener {
    private static final long serialVersionUID = 1L;
    private Color color;
    private int cellW;
    private int cellH;
    private CursorFactory cursorFactory = new CursorFactory();
    private Cursor handCursor;
    private Cursor defaultCursor;
    private final EventListenerList listeners = new EventListenerList();

    public ColorChooser(Color c, int cellW, int cellH) {
        this.color = c;
        this.handCursor = this.cursorFactory.get("hand");
        this.defaultCursor = this.cursorFactory.get("default");
        this.cellW = cellW;
        this.cellH = cellH;
        this.setBorder(BorderFactory.createEtchedBorder(0));
        this.addMouseListener(this);
        this.setPreferredSize(new Dimension(cellW, cellH));
    }

    public ColorChooser(Color c) {
        this(c, 36, 24);
    }

    protected void paintComponent(Graphics g) {
        g.setColor(this.color);
        g.fillRect(2, 2, this.cellW, this.cellH);
    }

    public void mouseClicked(MouseEvent e) {
        Color c = JColorChooser.showDialog(this.getTopLevelAncestor(), Translator.get("choose_color"), this.color);
        if (c == null) {
            return;
        }
        this.color = c;
        this.fireColorSelected(c);
        this.repaint();
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        Container c = this.getTopLevelAncestor();
        this.defaultCursor = c.getCursor();
        c.setCursor(this.handCursor);
    }

    public void mouseExited(MouseEvent e) {
        this.getTopLevelAncestor().setCursor(this.defaultCursor);
    }

    public void addColorListener(ColorListener listener) {
        this.listeners.add(ColorListener.class, listener);
    }

    public void removeColorListener(ColorListener listener) {
        this.listeners.remove(ColorListener.class, listener);
    }

    public ColorListener[] getColorListeners() {
        return (ColorListener[])this.listeners.getListeners(ColorListener.class);
    }

    protected synchronized void fireColorSelected(Color color) {
        ColorListener[] table = this.getColorListeners();
        int idx = 0;
        while (idx < table.length) {
            table[idx].colorSelected(color);
            ++idx;
        }
    }
}

