/*
 * Decompiled with CFR 0.152.
 */
package graphics;

import graphics.ClickAndDragPane;
import gui.SFrame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public abstract class SelectionPane
extends ClickAndDragPane {
    private boolean leftDrag = false;
    private Rectangle area = new Rectangle(0, 0, 0, 0);

    public SelectionPane(SFrame frame) {
        super(frame);
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.leftDrag) {
            g.drawRect((int)this.area.getX(), (int)this.area.getY(), (int)this.area.getWidth(), (int)this.area.getHeight());
        }
    }

    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        this.area = new Rectangle(0, 0, 0, 0);
    }

    public void mouseReleased(MouseEvent e) {
        if (this.leftDrag) {
            this.manageSelection(this.area, e);
        }
        this.repaint();
        this.leftDrag = false;
    }

    protected void leftDragged(Point click, MouseEvent e) {
        this.leftDrag = true;
        int xmin = e.getX() < click.x ? e.getX() : click.x;
        int ymin = e.getY() < click.y ? e.getY() : click.y;
        int width = Math.abs(e.getX() - click.x);
        int height = Math.abs(e.getY() - click.y);
        this.area.setBounds(xmin, ymin, width, height);
        this.repaint();
    }

    protected abstract void rightDragged(Point var1, MouseEvent var2);

    protected abstract void leftShiftClick(MouseEvent var1);

    protected abstract void leftControlClick(MouseEvent var1);

    protected abstract void leftSimpleClick(MouseEvent var1);

    protected abstract void leftDoubleClick(MouseEvent var1);

    protected abstract void rightClick(MouseEvent var1);

    protected abstract void manageSelection(Rectangle var1, MouseEvent var2);
}

