/*
 * Decompiled with CFR 0.152.
 */
package graphics;

import geoTortue.TImagePainter;
import graphics.Display;
import graphics.SelectionPane;
import gui.SFrame;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public abstract class GraphicPane
extends SelectionPane {
    protected final Display display;
    int panX;
    int panY;
    protected double angle;
    private int mode = 0;

    public GraphicPane(SFrame fr, Display display) {
        super(fr);
        this.display = display;
        this.owner.getCursorFactory().addCursor("move", 7, 7);
        this.owner.getCursorFactory().addCursor("turn", 7, 7);
    }

    public void init() {
        this.display.resize(this.getSize());
        this.display.center();
        this.repaint();
    }

    public Display getDisplay() {
        return this.display;
    }

    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        if (e.getButton() != 3) {
            return;
        }
        if (!e.isControlDown()) {
            this.mode = 1;
            this.owner.setCursor("move");
            this.panX = this.display.panX;
            this.panY = this.display.panY;
        } else {
            this.mode = 2;
            this.owner.setCursor("turn");
            this.angle = this.display.angle;
        }
    }

    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        this.mode = 0;
        this.owner.setCursor("default");
    }

    protected void rightDragged(Point click, MouseEvent e) {
        if (this.mode == 0) {
            return;
        }
        if (this.mode == 1) {
            this.display.panX = this.panX + e.getX() - click.x;
            this.display.panY = this.panY + e.getY() - click.y;
        } else if (this.mode == 2) {
            this.display.angle = this.angle - (double)(e.getX() - click.x) * Math.PI / 180.0;
        }
        this.repaint();
    }

    public TImagePainter getImage() {
        TImagePainter img = new TImagePainter(this.getWidth(), this.getHeight());
        Graphics2D g2 = img.createGraphics();
        this.paint(g2);
        return img;
    }

    protected abstract void rightClick(MouseEvent var1);

    protected abstract void manageSelection(Rectangle var1, MouseEvent var2);

    protected abstract void leftShiftClick(MouseEvent var1);

    protected abstract void leftControlClick(MouseEvent var1);

    protected abstract void leftSimpleClick(MouseEvent var1);

    protected abstract void leftDoubleClick(MouseEvent var1);
}

