/*
 * Decompiled with CFR 0.152.
 */
package graphics;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.Random;

public class Display {
    public int width;
    public int height;
    public int panX;
    public int panY;
    public double unit = 100.0;
    public double angle;

    public Display(Component c) {
        this.width = c.getWidth();
        this.height = c.getHeight();
        this.panX = this.width / 2;
        this.panY = this.height / 2;
        this.unit = this.width / 8;
        this.angle = 0.0;
    }

    public void resize(Dimension d) {
        this.width = (int)d.getWidth();
        this.height = (int)d.getHeight();
    }

    public void center() {
        this.panX = this.width / 2;
        this.panY = this.height / 2;
    }

    public void center(Point p) {
        this.panX = this.width - p.x;
        this.panY = this.height - p.y;
    }

    public Point toScreen(double x, double y) {
        Point2D.Double p = this.rotate(x, y, this.angle);
        int i = this.arrondi((double)this.panX + p.x * this.unit);
        int j = this.arrondi((double)this.panY - p.y * this.unit);
        return new Point(i, j);
    }

    private int arrondi(double x) {
        int n = (int)x;
        if (x - (double)n < 0.5) {
            return n;
        }
        return n + 1;
    }

    public Point toScreen(Point2D.Double p) {
        return this.toScreen(p.x, p.y);
    }

    public Point toScreen(Point p) {
        return this.toScreen(p.x, p.y);
    }

    public Point2D.Double getCoordinates(Point p) {
        double x = (double)(p.x - this.panX) / this.unit;
        double y = (double)(this.panY - p.y) / this.unit;
        return this.rotate(x, y, -this.angle);
    }

    public Point getRandomPixel() {
        Random rand = new Random();
        int i = rand.nextInt(this.width);
        int j = rand.nextInt(this.height);
        return new Point(i, j);
    }

    public Point2D.Double getRandomPoint() {
        Point p = this.getRandomPixel();
        return this.getCoordinates(new Point(p.x, p.y));
    }

    protected Point2D.Double rotate(double x, double y, double a) {
        double x1 = Math.cos(this.angle) * x - Math.sin(this.angle) * y;
        double y1 = Math.sin(this.angle) * x + Math.cos(this.angle) * y;
        return new Point2D.Double(x1, y1);
    }
}

