/*
 * Decompiled with CFR 0.152.
 */
package graphics;

import gui.SFrame;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;

public abstract class ClickPane
extends JPanel
implements MouseListener {
    protected SFrame owner;
    private String defaultCursor = "default";

    public ClickPane(SFrame frame) {
        this.owner = frame;
        this.setSize(this.owner.getWidth(), this.owner.getHeight());
        this.setBackground(Color.WHITE);
        this.addMouseListener(this);
    }

    public void mouseClicked(MouseEvent e) {
        switch (e.getButton()) {
            case 1: {
                switch (e.getClickCount()) {
                    case 1: {
                        if (e.isShiftDown()) {
                            this.leftShiftClick(e);
                            break;
                        }
                        if (e.isControlDown()) {
                            this.leftControlClick(e);
                            break;
                        }
                        this.leftSimpleClick(e);
                        break;
                    }
                    case 2: {
                        this.leftDoubleClick(e);
                    }
                }
                break;
            }
            case 3: {
                this.rightClick(e);
            }
        }
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        this.owner.setCursor(this.defaultCursor);
    }

    public void mouseExited(MouseEvent e) {
        this.owner.setDefaultCursor();
    }

    protected abstract void leftShiftClick(MouseEvent var1);

    protected abstract void leftControlClick(MouseEvent var1);

    protected abstract void leftSimpleClick(MouseEvent var1);

    protected abstract void leftDoubleClick(MouseEvent var1);

    protected abstract void rightClick(MouseEvent var1);

    public void setCursor(String name) {
        this.defaultCursor = name;
    }
}

