/*
 * Decompiled with CFR 0.152.
 */
package geoTortue;

import geoTortue.Config;
import geoTortue.Turtle;
import graphics.Display;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TurtleManager {
    protected Hashtable<String, Turtle> turtles = new Hashtable();
    private String currentTurtle = "T1";

    public TurtleManager() {
        this.turtles.put(this.currentTurtle, new Turtle());
    }

    public Turtle get(String key) {
        return this.turtles.get(key);
    }

    public void paint(Graphics g, Display display) {
        Graphics2D g2 = (Graphics2D)g;
        if (Config.antiAliasing) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        for (Turtle turtle : this.turtles.values()) {
            turtle.drawPath(g2, display);
            if (!turtle.isVisible()) continue;
            turtle.paint(g2, display);
        }
    }

    public Turtle getCurrentTurtle() {
        return this.turtles.get(this.currentTurtle);
    }

    public void setCurrentTurtle(String currentTurtle) {
        this.currentTurtle = currentTurtle;
    }

    public Vector<Turtle> getTurtlesInside(Display d, Rectangle r) {
        Vector<Turtle> v = new Vector<Turtle>();
        for (Turtle turtle : this.turtles.values()) {
            if (!turtle.isInside(d, r)) continue;
            v.add(turtle);
        }
        return v;
    }

    public Vector<Turtle> getTurtlesNear(Display d, Point p) {
        Vector<Turtle> v = new Vector<Turtle>();
        for (Turtle turtle : this.turtles.values()) {
            if (!turtle.isNear(d, p)) continue;
            v.add(turtle);
        }
        return v;
    }

    public void hideTurtles() {
        for (Turtle turtle : this.turtles.values()) {
            turtle.setVisible(false);
        }
    }

    public void showTurtles() {
        for (Turtle turtle : this.turtles.values()) {
            turtle.setVisible(true);
        }
    }
}

