/*
 * Decompiled with CFR 0.152.
 */
package geoTortue;

import geoTortue.Config;
import graphics.Display;
import gui.SFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class Turtle
implements ImageObserver {
    private Point2D.Double pos;
    private double alpha = 90.0;
    private boolean drawOnWalk = true;
    private Vector<Segment> path;
    private BufferedImage img;
    private Color color = Config.turtleColor;
    private Color pencilColor = Color.BLACK;
    private boolean visible = true;
    private int hotSpotX = 16;
    private int hotSpotY = 27;

    public Turtle() {
        this.pos = new Point2D.Double(0.0, 0.0);
        this.buildImage();
        this.setColor(this.color);
        this.clearPath();
    }

    private void buildImage() {
        try {
            URL url = this.getClass().getResource("/cfg/tortue.png");
            this.img = ImageIO.read(url);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setColor(Color color) {
        this.buildImage();
        int i = 0;
        while (i < this.img.getWidth()) {
            int j = 0;
            while (j < this.img.getHeight()) {
                int rgb = this.img.getRGB(i, j);
                if (rgb == -1) {
                    this.img.setRGB(i, j, color.getRGB());
                }
                ++j;
            }
            ++i;
        }
    }

    public void setPencilColor(Color color) {
        this.pencilColor = color;
    }

    public void paint(Graphics2D g, Display d) {
        Point p = d.toScreen(this.pos);
        double angle = (this.alpha - 90.0) * Math.PI / 180.0 + d.angle;
        g.translate(p.x - this.hotSpotX, p.y - this.hotSpotY);
        g.rotate(-angle, this.hotSpotX, this.hotSpotY);
        g.drawImage((Image)this.img, 0, 0, this);
        g.setColor(Color.RED);
        g.rotate(angle, this.hotSpotX, this.hotSpotY);
        g.translate(this.hotSpotX - p.x, this.hotSpotY - p.y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawPath(Graphics2D g, Display d) {
        g.setColor(this.pencilColor);
        Vector<Segment> vector = this.path;
        synchronized (vector) {
            for (Segment line : this.path) {
                line.paint(g, d);
            }
        }
    }

    public void walk(double d) {
        double x = this.pos.x;
        double y = this.pos.y;
        double dx = d * Math.cos(this.alpha * Math.PI / 180.0);
        double dy = d * Math.sin(this.alpha * Math.PI / 180.0);
        Point2D.Double newPos = new Point2D.Double(x + dx, y + dy);
        this.path.add(new Segment(this, newPos, this.drawOnWalk));
        this.pos = newPos;
    }

    public void turn(double x) {
        this.alpha += x;
    }

    public void drawOnWalk(boolean b) {
        this.drawOnWalk = b;
    }

    public void clearPath() {
        this.path = new Vector();
    }

    public Point2D.Double getPosition() {
        return this.pos;
    }

    public void setPosition(double x, double y) {
        this.pos = new Point2D.Double(x, y);
    }

    public void reset() {
        this.clearPath();
        this.pos = new Point2D.Double(0.0, 0.0);
        this.alpha = 90.0;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isInside(Display d, Rectangle r) {
        Point p = d.toScreen(this.pos);
        return r.contains(p);
    }

    public boolean isNear(Display d, Point p) {
        Point p1 = d.toScreen(this.pos);
        return p1.distance(p) < 16.0;
    }

    public void showDialog(SFrame fr, boolean modal) {
        System.out.println("dialog \u00e0 cr\u00e9er pour la tortue --- showDialog dans la classe Turtle");
    }

    public void showPopupMenu(Component owner, int x, int y) {
        JPopupMenu popup = new JPopupMenu();
        popup.add(new JMenuItem("menu \u00e0 faire"));
        popup.show(owner, x, y);
    }

    public boolean imageUpdate(Image arg0, int infoflags, int x, int y, int width, int height) {
        return true;
    }

    public void setAngle(double alpha) {
        this.alpha = alpha;
    }

    public Color getColor() {
        return this.color;
    }

    protected class Segment {
        public final Point2D.Double start;
        public final Point2D.Double end;
        private final boolean visible;

        public Segment(Turtle t, Point2D.Double e, boolean visible) {
            this.start = t.pos;
            this.end = e;
            this.visible = visible;
        }

        public void paint(Graphics g, Display d) {
            if (this.visible) {
                Point s = d.toScreen(this.start);
                Point e = d.toScreen(this.end);
                g.drawLine(s.x, s.y, e.x, e.y);
            }
        }
    }
}

