/*
 * Decompiled with CFR 0.152.
 */
package geoTortue;

import code.CommandManager;
import code.CommandManager2;
import code.ProcedureManager;
import exceptions.LowWeightException;
import files.Translator;
import geoTortue.Config;
import geoTortue.TDocuments;
import geoTortue.TGraphicPane;
import geoTortue.TImagePainter;
import geoTortue.TurtleManager;
import graphics.Display;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.geom.Point2D;
import javax.swing.JOptionPane;

public final class TManager
extends CommandManager2 {
    final TDocuments.ProcDoc procDoc = new TDocuments.ProcDoc();
    final ProcedureManager procManager = new ProcedureManager(this, this.procDoc);
    final TurtleManager turtleManager;
    TGraphicPane graphicPane;
    private boolean hasBeenModified = false;
    private String calculations = "";

    public TManager(TurtleManager tm, TGraphicPane gp) {
        super(new TDocuments.CommandDoc());
        this.turtleManager = tm;
        this.graphicPane = gp;
        new CommandManager.Command(this, "assign"){

            public void execute(String ... args) throws LowWeightException {
                TManager.this.testArity(args, 2, this.key);
                String name = TManager.this.getSymbol(args[0]);
                double x = TManager.this.getNumber(args[1]);
                TManager.this.jep.addVariable(name, x);
                TManager.this.commandDoc.addVariableKeyword(name);
                TManager.this.procDoc.addVariableKeyword(name);
            }
        };
        new CommandManager.Command(this, "clear"){

            public void execute(String ... args) throws LowWeightException {
                TManager.this.testArity(args, 1, this.key);
                String name = args[0];
                TManager.this.jep.removeVariable(name);
                TManager.this.commandDoc.removeVariableKeyword(name);
                TManager.this.procDoc.removeVariableKeyword(name);
            }
        };
        new CommandManager.Command(this, "AV"){

            public void execute(String ... args) throws LowWeightException {
                TManager.this.testArity(args, 1, this.key);
                double x = TManager.this.getNumber(args[0]);
                TManager.this.turtleManager.getCurrentTurtle().walk(x);
            }
        };
        new CommandManager.Command(this, "RE"){

            public void execute(String ... args) throws LowWeightException {
                TManager.this.testArity(args, 1, this.key);
                double x = TManager.this.getNumber(args[0]);
                TManager.this.turtleManager.getCurrentTurtle().walk(-x);
            }
        };
        new CommandManager.Command(this, "TD"){

            public void execute(String ... args) throws LowWeightException {
                TManager.this.testArity(args, 1, this.key);
                double x = TManager.this.getNumber(args[0]);
                TManager.this.turtleManager.getCurrentTurtle().turn(-x);
            }
        };
        new CommandManager.Command(this, "TG"){

            public void execute(String ... args) throws LowWeightException {
                TManager.this.testArity(args, 1, this.key);
                double x = TManager.this.getNumber(args[0]);
                TManager.this.turtleManager.getCurrentTurtle().turn(x);
            }
        };
        new CommandManager.Command(this, "CT"){

            public void execute(String ... args) throws LowWeightException {
                TManager.this.turtleManager.getCurrentTurtle().setVisible(false);
            }
        };
        new CommandManager.Command(this, "MT"){

            public void execute(String ... args) throws LowWeightException {
                TManager.this.turtleManager.getCurrentTurtle().setVisible(true);
            }
        };
        new CommandManager.Command(this, "VG"){

            public void execute(String ... args) throws LowWeightException {
                TManager.this.turtleManager.getCurrentTurtle().reset();
            }
        };
        new CommandManager.Command(this, "BC"){

            public void execute(String ... args) throws LowWeightException {
                TManager.this.turtleManager.getCurrentTurtle().drawOnWalk(true);
            }
        };
        new CommandManager.Command(this, "LC"){

            public void execute(String ... args) throws LowWeightException {
                TManager.this.turtleManager.getCurrentTurtle().drawOnWalk(false);
            }
        };
        new CommandManager.Command(this, "teleporter"){

            public void execute(String ... args) throws LowWeightException {
                TManager.this.testArity(args, 2, this.key);
                double x = TManager.this.getNumber(args[0]);
                double y = TManager.this.getNumber(args[1]);
                TManager.this.turtleManager.getCurrentTurtle().setPosition(x, y);
            }
        };
        new CommandManager.Command(this, "orienter"){

            public void execute(String ... args) throws LowWeightException {
                TManager.this.testArity(args, 1, this.key);
                double x = TManager.this.getNumber(args[0]);
                TManager.this.turtleManager.getCurrentTurtle().setAngle(90.0 - x);
            }
        };
        new CommandManager.Command(this, "REP"){

            public void execute(String ... args) throws LowWeightException {
                if (args.length < 1) {
                    throw new LowWeightException("repException", new String[0]);
                }
                int n = (int)TManager.this.getNumber(args[0]);
                String command = "";
                int idx = 1;
                while (idx < args.length) {
                    command = String.valueOf(command) + args[idx] + " ";
                    ++idx;
                }
                idx = 0;
                while (idx < n) {
                    TManager.this.process(command);
                    ++idx;
                }
            }
        };
        new CommandManager.Command(this, "SI"){

            public void execute(String ... args) throws LowWeightException {
                if (args.length < 3) {
                    throw new LowWeightException("siException", new String[0]);
                }
                if (!args[1].toLowerCase().equals("alors")) {
                    throw new LowWeightException("alorsException", new String[0]);
                }
                int condition = (int)TManager.this.getNumber(args[0]);
                if (condition == 1) {
                    TManager.this.process(args[2]);
                } else if (args.length > 4) {
                    if (!args[3].toLowerCase().equals("sinon")) {
                        throw new LowWeightException("sinonException", new String[0]);
                    }
                    TManager.this.process(args[4]);
                }
            }
        };
        new CommandManager.Command(this, "STOP"){

            public void execute(String ... args) throws LowWeightException {
                TManager.this.interrupt();
            }
        };
    }

    public synchronized void launchExecution(String str) throws LowWeightException {
        this.calculations = "";
        this.procManager.parse();
        super.launchExecution(str);
        this.procDoc.refresh();
        this.commandDoc.refresh();
        this.graphicPane.repaint();
        if (this.calculations.length() > 0) {
            try {
                JOptionPane.showMessageDialog(this.graphicPane.getTopLevelAncestor(), this.calculations, Translator.get("calculator"), -1);
            }
            catch (HeadlessException e) {
                e.printStackTrace();
            }
        }
    }

    protected void processSingleCommand(String str) throws LowWeightException {
        try {
            double x = this.getNumber(str);
            this.calculations = String.valueOf(this.calculations) + "    " + str.trim() + " = " + x + "\n";
        }
        catch (LowWeightException e) {
            super.processSingleCommand(str);
        }
        if (Config.showPath && !this.interrupted) {
            try {
                Thread.sleep(Config.commandDelay);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.graphicPane.paintImmediately(this.graphicPane.getBounds());
        }
    }

    public void executeCommand(String key, String ... args) throws LowWeightException {
        if (this.containsKey(key = key.toLowerCase())) {
            this.getCommand(key).execute(args);
        } else {
            this.procManager.processProc(key, args);
        }
    }

    public TImagePainter getImage() {
        boolean antiAlias = Config.antiAliasing;
        Config.antiAliasing = true;
        TImagePainter img = this.graphicPane.getImage();
        Config.antiAliasing = antiAlias;
        return img;
    }

    public TImagePainter getRawImage() {
        boolean antiAlias = Config.antiAliasing;
        Config.antiAliasing = false;
        TImagePainter img = this.graphicPane.getImage();
        Config.antiAliasing = antiAlias;
        return img;
    }

    public void centerGraphics() {
        this.graphicPane.init();
        this.graphicPane.repaint();
    }

    public void centerCurrentTurtle() {
        Point2D.Double pos = this.turtleManager.getCurrentTurtle().getPosition();
        Display display = this.graphicPane.getDisplay();
        display.center();
        Point p = display.toScreen(pos);
        display.center(p);
        this.graphicPane.repaint();
    }

    public void resetAngle() {
        this.graphicPane.getDisplay().angle = 0.0;
        this.graphicPane.repaint();
    }

    public boolean hasBeenModified() {
        return this.hasBeenModified;
    }

    public void setModified(boolean b) {
        this.hasBeenModified = b;
    }
}

