/*
 * Decompiled with CFR 0.152.
 */
package geoTortue;

import files.Translator;
import geoTortue.Turtle;
import geoTortue.TurtleManager;
import graphics.Display;
import graphics.GraphicPane;
import gui.SFrame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import javax.imageio.ImageIO;

public class TGraphicPane
extends GraphicPane {
    private static final long serialVersionUID = 1590337927078695991L;
    final TurtleManager turtleManager;
    BufferedImage backGImg = null;
    int imgOffsetX;
    int imgOffsetY = 0;
    String backImgPath = null;

    public TGraphicPane(TurtleManager tm, Display d, SFrame owner) {
        super(owner, d);
        this.turtleManager = tm;
        this.display.unit = 1.0;
    }

    public void update(Graphics g) {
        super.update(g);
    }

    public void paint(Graphics g) {
        super.paint(g);
        Point p = this.display.toScreen(0.0, 0.0);
        Graphics2D g2 = (Graphics2D)g;
        g.translate(p.x, p.y);
        g2.rotate(-this.display.angle, 0.0, 0.0);
        g.drawImage(this.backGImg, -this.imgOffsetX, -this.imgOffsetY, this);
        g2.rotate(this.display.angle, 0.0, 0.0);
        g.translate(-p.x, -p.y);
        this.turtleManager.paint(g, this.display);
        this.paintBorder(g);
    }

    protected void rightClick(MouseEvent e) {
        for (Turtle turtle : this.turtleManager.getTurtlesNear(this.display, e.getPoint())) {
            turtle.showPopupMenu(this, e.getX(), e.getY());
        }
    }

    protected void manageSelection(Rectangle r, MouseEvent e) {
        for (Turtle turtle : this.turtleManager.getTurtlesInside(this.display, r)) {
            System.out.println(turtle);
        }
    }

    protected void leftShiftClick(MouseEvent e) {
        Graphics g = this.getGraphics();
        this.paint(g);
        g.fillRect(0, 0, 20, 20);
    }

    protected void leftControlClick(MouseEvent e) {
    }

    protected void leftSimpleClick(MouseEvent e) {
    }

    protected void leftDoubleClick(MouseEvent e) {
        for (Turtle turtle : this.turtleManager.getTurtlesNear(this.display, e.getPoint())) {
            turtle.showDialog(this.owner, true);
        }
    }

    public void mouseMoved(MouseEvent e) {
        super.mouseMoved(e);
        Vector<Turtle> figs = this.turtleManager.getTurtlesNear(this.display, e.getPoint());
        switch (figs.size()) {
            case 0: {
                this.setToolTipText(null);
                this.owner.setCursor("default");
                return;
            }
            case 1: {
                this.owner.setCursor("hand");
                this.setToolTipText("GeoTortue v0.12");
                return;
            }
        }
    }

    public void setBackgroundImg(URL url) throws IOException {
        this.backGImg = ImageIO.read(url);
        this.backImgPath = url.getFile();
        this.initImgOffset();
    }

    public void setBackgroundImg(File file) throws IOException {
        this.backGImg = ImageIO.read(file);
        this.backImgPath = file.getName();
        this.initImgOffset();
    }

    private void initImgOffset() {
        this.imgOffsetX = this.backGImg.getWidth() / 2;
        this.imgOffsetY = this.backGImg.getHeight() / 2;
    }

    public String backImgSize() {
        if (this.backGImg != null) {
            return String.valueOf(this.backGImg.getWidth()) + " x " + this.backGImg.getHeight();
        }
        return "N/A";
    }

    public String backImgFile() {
        if (this.backImgPath != null) {
            return this.backImgPath;
        }
        return Translator.get("no_image");
    }
}

