/*
 * Decompiled with CFR 0.152.
 */
package geoTortue;

import geoTortue.TImagePainter;
import graphics.ClickPane;
import gui.SFrame;
import gui.SimpleColorChooser;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.EventListener;
import java.util.Stack;
import javax.swing.event.EventListenerList;

public final class TDrawPane
extends ClickPane {
    private static final long serialVersionUID = 2799112691079829114L;
    private final TImagePainter rawImg0;
    private final TImagePainter smoothImage0;
    private Stack<UndoElement> undoElmts = new Stack();
    private Stack<UndoElement> redoElmts = new Stack();
    private TImagePainter rawImg;
    private TImagePainter img;
    protected final int imgWidth;
    protected final int imgHeight;
    private SimpleColorChooser colorChooser;
    public static final int FLOOD_MODE = 1;
    public static final int PICK_MODE = 2;
    protected int mode = 1;
    private boolean hasBeenModified = false;
    private final EventListenerList listeners = new EventListenerList();

    public TDrawPane(SFrame frame, TImagePainter smooth, TImagePainter raw, SimpleColorChooser chooser) {
        super(frame);
        this.colorChooser = chooser;
        this.setBackground(new Color(200, 200, 200));
        this.rawImg0 = raw;
        this.smoothImage0 = smooth;
        this.rawImg = new TImagePainter(this.rawImg0);
        this.img = new TImagePainter(this.rawImg0);
        this.img.multiply(this.smoothImage0);
        this.imgWidth = this.rawImg.getWidth();
        this.imgHeight = this.rawImg.getHeight();
        this.setPreferredSize(new Dimension(this.imgWidth, this.imgHeight));
        this.owner.getCursorFactory().addCursor("flood", 12, 14);
        this.owner.getCursorFactory().addCursor("picker", 0, 10);
        this.setCursor("flood");
    }

    public void paint(Graphics g) {
        super.paint(g);
        int xOffset = (this.getWidth() - this.imgWidth) / 2;
        int yOffset = (this.getHeight() - this.imgHeight) / 2;
        g.drawRect(xOffset - 1, yOffset - 1, this.imgWidth + 2, this.imgHeight + 2);
        g.drawRect(xOffset - 3, yOffset - 3, this.imgWidth + 6, this.imgHeight + 6);
        g.drawImage(this.img, xOffset, yOffset, this);
    }

    public void setMode(int mode) {
        this.mode = mode;
        switch (mode) {
            case 1: {
                this.setCursor("flood");
                this.owner.setCursor("flood");
                break;
            }
            case 2: {
                this.setCursor("picker");
                this.owner.setCursor("picker");
                break;
            }
        }
    }

    public void revertToOriginal() {
        this.rawImg = new TImagePainter(this.rawImg0);
        this.img = new TImagePainter(this.rawImg0);
        this.img.multiply(this.smoothImage0);
        this.undoElmts = new Stack();
        this.redoElmts = new Stack();
        this.fireCanUndo(false);
        this.fireCanRedo(false);
        this.repaint();
    }

    public void undo() {
        if (!this.undoElmts.isEmpty()) {
            UndoElement undo = this.undoElmts.pop();
            int x = undo.x;
            int y = undo.y;
            if (this.redoElmts.isEmpty()) {
                this.fireCanRedo(true);
            }
            this.redoElmts.add(new UndoElement(x, y, this.rawImg.getRGB(x, y)));
            this.flood(x, y, undo.c);
            this.repaint();
        }
        if (this.undoElmts.isEmpty()) {
            this.fireCanUndo(false);
        }
    }

    public void redo() {
        if (!this.redoElmts.isEmpty()) {
            UndoElement redo = this.redoElmts.pop();
            int x = redo.x;
            int y = redo.y;
            if (this.undoElmts.isEmpty()) {
                this.fireCanUndo(true);
            }
            this.undoElmts.add(new UndoElement(x, y, this.rawImg.getRGB(x, y)));
            this.flood(x, y, redo.c);
            this.repaint();
        }
        if (this.redoElmts.isEmpty()) {
            this.fireCanRedo(false);
        }
    }

    public void setModified(boolean b) {
        this.hasBeenModified = b;
    }

    public boolean hasBeenModified() {
        return this.hasBeenModified;
    }

    protected void leftSimpleClick(MouseEvent e) {
        int xOffset = (this.getWidth() - this.imgWidth) / 2;
        int yOffset = (this.getHeight() - this.imgHeight) / 2;
        int x = e.getX() - xOffset;
        int y = e.getY() - yOffset;
        if (x >= 0 && x < this.imgWidth && y >= 0 && y < this.imgHeight) {
            switch (this.mode) {
                case 1: {
                    if (this.undoElmts.isEmpty()) {
                        this.fireCanUndo(true);
                    }
                    this.undoElmts.add(new UndoElement(x, y, this.rawImg.getRGB(x, y)));
                    this.flood(x, y, this.colorChooser.getCurrentColor().getRGB());
                    break;
                }
                case 2: {
                    int col = this.img.getRGB(x, y);
                    this.colorChooser.setColor(new Color(col));
                    break;
                }
            }
        }
    }

    private void flood(int x, int y, int c) {
        this.rawImg.floodFill(x, y, c);
        this.img = new TImagePainter(this.rawImg);
        this.img.multiply(this.smoothImage0);
        this.hasBeenModified = true;
        this.owner.repaint();
    }

    public BufferedImage getImage() {
        return this.img;
    }

    protected void leftShiftClick(MouseEvent e) {
    }

    protected void leftControlClick(MouseEvent e) {
    }

    protected void leftDoubleClick(MouseEvent e) {
    }

    protected void rightClick(MouseEvent e) {
    }

    public void addListener(UndoListener listener) {
        this.listeners.add(UndoListener.class, listener);
    }

    public void removeListener(UndoListener listener) {
        this.listeners.remove(UndoListener.class, listener);
    }

    public UndoListener[] getListeners() {
        return (UndoListener[])this.listeners.getListeners(UndoListener.class);
    }

    protected synchronized void fireCanUndo(boolean b) {
        UndoListener[] table = this.getListeners();
        int idx = 0;
        while (idx < table.length) {
            table[idx].canUndo(b);
            ++idx;
        }
    }

    protected synchronized void fireCanRedo(boolean b) {
        UndoListener[] table = this.getListeners();
        int idx = 0;
        while (idx < table.length) {
            table[idx].canRedo(b);
            ++idx;
        }
    }

    private class UndoElement {
        int x;
        int y;
        int c;

        UndoElement(int x, int y, int c) {
            this.x = x;
            this.y = y;
            this.c = c;
        }
    }

    public static interface UndoListener
    extends EventListener {
        public void canUndo(boolean var1);

        public void canRedo(boolean var1);
    }
}

