/*
 * Decompiled with CFR 0.152.
 */
package geoTortue;

import code.SyntaxStyles;
import files.Translator;
import geoTortue.Config;
import geoTortue.Logo;
import gui.ColorChooser;
import gui.ColorListener;
import gui.KVPanel;
import gui.VerticalPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;

public class PreferencesDialog
extends JDialog
implements KeyListener {
    private static final long serialVersionUID = -9166868685028382762L;
    private Logo logo;
    private JButton saveButton;
    private JButton fileButton;
    private JLabel imgSizeLabel;
    private JCheckBox showPathCheckBox;
    private JCheckBox antiAliasCheckBox;
    private JSpinner delaySpinner;
    private JSpinner graphicsWidthSpinner;
    private JSpinner graphicsHeightSpinner;
    private JSpinner backImgOffsetXSpinner;
    private JSpinner backImgOffsetYSpinner;
    private ColorChooser turtleCC;

    public PreferencesDialog(Logo l) {
        super(l.getFrame(), Translator.get("preferences"), true);
        this.logo = l;
        this.showPathCheckBox = new JCheckBox("", Config.showPath);
        this.showPathCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Config.showPath = PreferencesDialog.this.showPathCheckBox.isSelected();
                PreferencesDialog.this.delaySpinner.setEnabled(PreferencesDialog.this.showPathCheckBox.isSelected());
            }
        });
        this.delaySpinner = new JSpinner(new SpinnerNumberModel(Config.commandDelay, 0, 1000, 1));
        this.delaySpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                int x;
                Config.commandDelay = x = ((Integer)((SpinnerNumberModel)PreferencesDialog.this.delaySpinner.getModel()).getNumber()).intValue();
            }
        });
        this.antiAliasCheckBox = new JCheckBox("", Config.antiAliasing);
        this.antiAliasCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Config.antiAliasing = PreferencesDialog.this.antiAliasCheckBox.isSelected();
                ((PreferencesDialog)PreferencesDialog.this).logo.manager.graphicPane.repaint();
            }
        });
        this.saveButton = new JButton(Translator.get("save_config"));
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Config.save();
                PreferencesDialog.this.dispose();
            }
        });
        this.graphicsWidthSpinner = new JSpinner(new SpinnerNumberModel(Config.graphicsDimension.width, 200, 2048, 1));
        this.graphicsWidthSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                int x;
                Config.graphicsDimension.width = x = ((Integer)((SpinnerNumberModel)PreferencesDialog.this.graphicsWidthSpinner.getModel()).getNumber()).intValue();
                PreferencesDialog.this.logo.getFrame().validate();
            }
        });
        this.graphicsHeightSpinner = new JSpinner(new SpinnerNumberModel(Config.graphicsDimension.height, 200, 1536, 1));
        this.graphicsHeightSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                int x;
                Config.graphicsDimension.height = x = ((Integer)((SpinnerNumberModel)PreferencesDialog.this.graphicsHeightSpinner.getModel()).getNumber()).intValue();
                PreferencesDialog.this.logo.getFrame().validate();
            }
        });
        this.backImgOffsetXSpinner = new JSpinner(new SpinnerNumberModel(this.logo.graphicPane.imgOffsetX, -2048, 2048, 1));
        this.backImgOffsetXSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                int x;
                ((PreferencesDialog)PreferencesDialog.this).logo.graphicPane.imgOffsetX = x = ((Integer)((SpinnerNumberModel)PreferencesDialog.this.backImgOffsetXSpinner.getModel()).getNumber()).intValue();
                ((PreferencesDialog)PreferencesDialog.this).logo.graphicPane.repaint();
            }
        });
        this.backImgOffsetYSpinner = new JSpinner(new SpinnerNumberModel(this.logo.graphicPane.imgOffsetY, -2048, 2048, 1));
        this.backImgOffsetYSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                int x;
                ((PreferencesDialog)PreferencesDialog.this).logo.graphicPane.imgOffsetY = x = ((Integer)((SpinnerNumberModel)PreferencesDialog.this.backImgOffsetYSpinner.getModel()).getNumber()).intValue();
                ((PreferencesDialog)PreferencesDialog.this).logo.graphicPane.repaint();
            }
        });
        this.turtleCC = new ColorChooser(Config.turtleColor);
        this.turtleCC.addColorListener(new ColorListener(){

            public void colorSelected(Color c) {
                ((PreferencesDialog)PreferencesDialog.this).logo.turtleManager.getCurrentTurtle().setColor(c);
                Config.turtleColor = c;
                PreferencesDialog.this.logo.getFrame().repaint();
            }
        });
        this.imgSizeLabel = new JLabel(this.logo.graphicPane.backImgSize());
        this.fileButton = new JButton(this.logo.graphicPane.backImgFile());
        this.fileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreferencesDialog.this.logo.loadBackgroundImg();
                PreferencesDialog.this.fileButton.setText(((PreferencesDialog)PreferencesDialog.this).logo.graphicPane.backImgFile());
                PreferencesDialog.this.imgSizeLabel.setText(((PreferencesDialog)PreferencesDialog.this).logo.graphicPane.backImgSize());
                PreferencesDialog.this.backImgOffsetXSpinner.getModel().setValue(((PreferencesDialog)PreferencesDialog.this).logo.graphicPane.imgOffsetX);
                PreferencesDialog.this.backImgOffsetYSpinner.getModel().setValue(((PreferencesDialog)PreferencesDialog.this).logo.graphicPane.imgOffsetY);
            }
        });
        ((JSpinner.DefaultEditor)this.delaySpinner.getEditor()).getTextField().addKeyListener(this);
        ((JSpinner.DefaultEditor)this.graphicsWidthSpinner.getEditor()).getTextField().addKeyListener(this);
        ((JSpinner.DefaultEditor)this.graphicsHeightSpinner.getEditor()).getTextField().addKeyListener(this);
        ((JSpinner.DefaultEditor)this.backImgOffsetXSpinner.getEditor()).getTextField().addKeyListener(this);
        ((JSpinner.DefaultEditor)this.backImgOffsetYSpinner.getEditor()).getTextField().addKeyListener(this);
        this.showPathCheckBox.addKeyListener(this);
        this.antiAliasCheckBox.addKeyListener(this);
        this.saveButton.addKeyListener(this);
        this.fileButton.addKeyListener(this);
        JPanel mainPane = new JPanel(new BorderLayout());
        JTabbedPane tabbedPane = new JTabbedPane();
        KVPanel turtlePath = new KVPanel(Translator.get("turtle_path"), new Component[0]);
        turtlePath.add(new JLabel(Translator.get("turtle_showpath")));
        turtlePath.add(this.showPathCheckBox);
        turtlePath.add(new JLabel(Translator.get("turtle_delay")));
        turtlePath.add(this.delaySpinner);
        KVPanel turtleColor = new KVPanel(Translator.get("turtle_drawing"), new Component[0]);
        turtleColor.add(new JLabel(Translator.get("turtle_color")));
        turtleColor.add(this.turtleCC);
        KVPanel antiAlias = new KVPanel(Translator.get("graphics_quality"), new Component[0]);
        antiAlias.add(new JLabel(Translator.get("anti_aliasing")));
        antiAlias.add(this.antiAliasCheckBox);
        KVPanel graphics = new KVPanel(Translator.get("graphicPane"), 10, 10, new Component[0]);
        graphics.add(new JLabel(Translator.get("graphicsWidth")));
        graphics.add(this.graphicsWidthSpinner);
        graphics.add(new JLabel(Translator.get("graphicsHeight")));
        graphics.add(this.graphicsHeightSpinner);
        KVPanel backImg = new KVPanel(Translator.get("background_image"), 10, 10, new Component[0]);
        backImg.add(new JLabel(Translator.get("image_file")));
        backImg.add(this.fileButton);
        backImg.add(new JLabel(Translator.get("image_size")));
        backImg.add(this.imgSizeLabel);
        backImg.add(new JLabel(Translator.get("back_img_offset_x")));
        backImg.add(this.backImgOffsetXSpinner);
        backImg.add(new JLabel(Translator.get("back_img_offset_y")));
        backImg.add(this.backImgOffsetYSpinner);
        KVPanel syntax = new KVPanel(null, new Component[0]);
        syntax.add(new JLabel(Translator.get("color_normal")));
        syntax.add(this.createColorChooser(SyntaxStyles.normal));
        syntax.add(new JLabel(Translator.get("color_comment")));
        syntax.add(this.createColorChooser(SyntaxStyles.comment));
        syntax.add(new JLabel(Translator.get("color_keyword")));
        syntax.add(this.createColorChooser(SyntaxStyles.keyword));
        syntax.add(new JLabel(Translator.get("color_command")));
        syntax.add(this.createColorChooser(SyntaxStyles.command));
        syntax.add(new JLabel(Translator.get("color_procedure")));
        syntax.add(this.createColorChooser(SyntaxStyles.procedure));
        syntax.add(new JLabel(Translator.get("color_argument")));
        syntax.add(this.createColorChooser(SyntaxStyles.argument));
        syntax.add(new JLabel(Translator.get("color_variable")));
        syntax.add(this.createColorChooser(SyntaxStyles.variable));
        VerticalPanel turtlePane = new VerticalPanel(turtlePath, turtleColor);
        VerticalPanel graphicPane = new VerticalPanel(graphics, antiAlias, backImg);
        VerticalPanel syntaxPane = new VerticalPanel(syntax);
        tabbedPane.add((Component)turtlePane, Translator.get("turtle_option"));
        tabbedPane.add((Component)graphicPane, Translator.get("graphic_option"));
        tabbedPane.add((Component)syntaxPane, Translator.get("syntax_highlight"));
        mainPane.add((Component)tabbedPane, "Center");
        mainPane.add((Component)this.saveButton, "South");
        this.add(mainPane);
        tabbedPane.addKeyListener(this);
        this.addKeyListener(this);
        this.pack();
        this.setSize(500, 500);
        this.setLocationRelativeTo(this.getOwner());
        this.setVisible(true);
    }

    public void keyTyped(KeyEvent e) {
        if (e.getKeyChar() == '\u001b') {
            this.dispose();
        }
    }

    public void keyPressed(KeyEvent arg0) {
    }

    public void keyReleased(KeyEvent arg0) {
    }

    private ColorChooser createColorChooser(MutableAttributeSet set) {
        final MutableAttributeSet s = set;
        ColorChooser cc = new ColorChooser(StyleConstants.getForeground(set));
        cc.addColorListener(new ColorListener(){

            public void colorSelected(Color c) {
                StyleConstants.setForeground(s, c);
                ((PreferencesDialog)PreferencesDialog.this).logo.manager.procDoc.refresh();
                ((PreferencesDialog)PreferencesDialog.this).logo.manager.getCommandDoc().refresh();
            }
        });
        return cc;
    }
}

