/*
 * Decompiled with CFR 0.152.
 */
package geoTortue;

import apps.FileFilter2;
import apps.GraphicApplication;
import apps.SysCommandManager;
import code.CommandManager;
import code.SyntaxStyles;
import exceptions.LowWeightException;
import files.Translator;
import geoTortue.Config;
import geoTortue.GeoTortue;
import geoTortue.LogoLayout;
import geoTortue.PreferencesDialog;
import geoTortue.TCommandPane;
import geoTortue.TGraphicPane;
import geoTortue.TManager;
import geoTortue.TProcPane;
import geoTortue.TurtleManager;
import gui.DecoratedPane;
import gui.HTMLFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import painter.TurtlePainter;

public final class Logo
extends GraphicApplication
implements CommandManager.CommandManagerListener {
    final TManager manager;
    final TurtleManager turtleManager;
    final Config config;
    TGraphicPane graphicPane;
    TCommandPane commandPane;
    TProcPane procPane;
    private DecoratedPane commands;
    private DecoratedPane procs;
    private JPanel mainPane = new JPanel(new LogoLayout());
    boolean procsMaximized = true;
    private int threadNumber = 0;
    File imgDir = null;

    public Logo(Config c) {
        super("GeoTortue v0.12", "geoTortue", "/cfg/");
        this.config = c;
        this.extension = "txt";
        this.admissibleExtensions = new String[]{"txt"};
        SyntaxStyles.installDefaults();
        Translator.build(this.getClass().getResource(String.valueOf(this.cfgDir) + "geoTortueExceptions.html"));
        this.turtleManager = new TurtleManager();
        this.graphicPane = new TGraphicPane(this.turtleManager, this.display, this.frame);
        this.manager = new TManager(this.turtleManager, this.graphicPane);
        this.manager.addListener(this);
        this.commandPane = new TCommandPane(this.manager);
        this.procPane = new TProcPane(this.manager);
        URL url = this.getClass().getResource(String.valueOf(this.cfgDir) + "icon.gif");
        if (url != null) {
            try {
                this.frame.setIconImage(ImageIO.read(url));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.setButtonEnabled("stop", false);
        this.graphicPane.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.mainPane.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.commands = new DecoratedPane(this.commandPane, Translator.get("commandPane"));
        this.procs = new DecoratedPane(this.procPane, Translator.get("procPane"), new AbstractAction(""){
            private static final long serialVersionUID = 6358592575137519683L;

            public void actionPerformed(ActionEvent arg0) {
                Logo.this.toggleLayout();
            }
        }, Translator.get("toggle_layout"));
        this.toggleLayout();
        this.frame.getContentPane().add((Component)this.mainPane, "Center");
        this.frame.pack();
        this.commandPane.grabFocus();
        this.frame.setBounds(2, 2, 1020, 730);
        this.frame.setVisible(true);
        this.frame.setExtendedState(6);
        this.graphicPane.init();
        this.manager.centerCurrentTurtle();
    }

    public void newFrame() {
        new Logo(this.config);
    }

    public void load(File file) {
        this.manager.procManager.clear();
        try {
            FileReader reader = new FileReader(file);
            String text = "";
            int c = reader.read();
            while (c >= 0) {
                text = String.valueOf(text) + (char)c;
                c = reader.read();
            }
            this.manager.procDoc.setText(text);
            this.manager.setModified(false);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public String getFileDescription() {
        return Translator.get("logoFilesDescription");
    }

    public boolean save(File file) {
        try {
            FileWriter writer = new FileWriter(file);
            writer.flush();
            writer.write(this.manager.procDoc.getWholeText());
            writer.close();
            this.manager.setModified(false);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    protected void registerNewCommands() {
        super.registerNewCommands();
        SysCommandManager sysCommandManager = this.sysCommandManager;
        sysCommandManager.getClass();
        new SysCommandManager.SysCommand(sysCommandManager, "paint", "applications-graphics", 128, 80){

            public void execute(String ... args) throws LowWeightException {
                new TurtlePainter(Logo.this.cfgDir, Logo.this.manager.getImage(), Logo.this.manager.getRawImage());
            }
        };
        SysCommandManager sysCommandManager2 = this.sysCommandManager;
        sysCommandManager2.getClass();
        new SysCommandManager.SysCommand(sysCommandManager2, "help", "help-browser", 0, 112){

            public void execute(String ... args) throws LowWeightException {
                URL url = this.getClass().getResource("/cfg/help/index.html");
                new HTMLFrame(url);
            }
        };
        SysCommandManager sysCommandManager3 = this.sysCommandManager;
        sysCommandManager3.getClass();
        new SysCommandManager.SysCommand(sysCommandManager3, "about", "weather-clear"){

            public void execute(String ... args) throws LowWeightException {
                new GeoTortue.Splash();
            }
        };
        SysCommandManager sysCommandManager4 = this.sysCommandManager;
        sysCommandManager4.getClass();
        new SysCommandManager.SysCommand(sysCommandManager4, "center_graphics", "", 128, 76){

            public void execute(String ... args) throws LowWeightException {
                Logo.this.manager.centerGraphics();
            }
        };
        SysCommandManager sysCommandManager5 = this.sysCommandManager;
        sysCommandManager5.getClass();
        new SysCommandManager.SysCommand(sysCommandManager5, "center_turtle", "", 128, 75){

            public void execute(String ... args) throws LowWeightException {
                Logo.this.manager.centerCurrentTurtle();
            }
        };
        SysCommandManager sysCommandManager6 = this.sysCommandManager;
        sysCommandManager6.getClass();
        new SysCommandManager.SysCommand(sysCommandManager6, "reset_angle", "", 128, 82){

            public void execute(String ... args) throws LowWeightException {
                Logo.this.manager.resetAngle();
            }
        };
        SysCommandManager sysCommandManager7 = this.sysCommandManager;
        sysCommandManager7.getClass();
        new SysCommandManager.SysCommand(sysCommandManager7, "stop", "process-stop", 0, 27){

            public void execute(String ... args) throws LowWeightException {
                Logo.this.manager.interrupt();
            }
        };
        SysCommandManager sysCommandManager8 = this.sysCommandManager;
        sysCommandManager8.getClass();
        new SysCommandManager.SysCommand(sysCommandManager8, "preferences", "preferences-system", 0, 123){

            public void execute(String ... args) throws LowWeightException {
                Logo.this.showPreferencesDialog();
            }
        };
        SysCommandManager sysCommandManager9 = this.sysCommandManager;
        sysCommandManager9.getClass();
        new SysCommandManager.SysCommand(sysCommandManager9, "insert_background_image", ""){

            public void execute(String ... args) throws LowWeightException {
                Logo.this.loadBackgroundImg();
            }
        };
        SysCommandManager sysCommandManager10 = this.sysCommandManager;
        sysCommandManager10.getClass();
        new SysCommandManager.SysCommand(sysCommandManager10, "toggle_layout", "", 128, 77){

            public void execute(String ... args) throws LowWeightException {
                Logo.this.toggleLayout();
            }
        };
    }

    public void showPreferencesDialog() {
        new PreferencesDialog(this);
    }

    protected boolean hasBeenModified() {
        return this.manager.hasBeenModified();
    }

    public void executionStarted() {
        ++this.threadNumber;
        this.setButtonEnabled("stop", true);
    }

    public void executionStopped() {
        --this.threadNumber;
        if (this.threadNumber == 0) {
            this.setButtonEnabled("stop", false);
        }
    }

    private void toggleLayout() {
        if (!this.procsMaximized) {
            this.mainPane.removeAll();
            this.mainPane.setLayout(new GridLayout(1, 1));
            this.mainPane.add(this.procs);
            this.procsMaximized = true;
            this.frame.validate();
        } else {
            this.mainPane.removeAll();
            this.mainPane.setLayout(new LogoLayout());
            this.mainPane.add(this.graphicPane);
            this.mainPane.add(this.commands);
            this.mainPane.add(this.procs);
            this.procsMaximized = false;
            this.frame.validate();
        }
    }

    public void loadBackgroundImg() {
        int returnVal;
        JFileChooser chooser = new JFileChooser();
        FileFilter2 filter = new FileFilter2(Translator.get("image_files"), ".png", ".gif", ".jpg");
        chooser.setDialogTitle(Translator.get("load"));
        chooser.setFileFilter(filter);
        if (this.imgDir != null) {
            chooser.setCurrentDirectory(this.imgDir);
        }
        if ((returnVal = chooser.showOpenDialog(this.frame)) == 0) {
            this.imgDir = chooser.getCurrentDirectory();
            try {
                this.manager.graphicPane.setBackgroundImg(chooser.getSelectedFile());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.frame.pack();
        }
    }
}

