/*
 * Decompiled with CFR 0.152.
 */
package geoTortue;

import code.SyntaxStyles;
import files.KVFile;
import files.KVTable;
import java.awt.Color;
import java.awt.Dimension;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import javax.swing.text.StyleConstants;

public class Config {
    public static String PATH = "config";
    public static URL URL;
    public static boolean antiAliasing;
    public static boolean showPath;
    public static int commandDelay;
    public static Dimension graphicsDimension;
    public static Color turtleColor;

    static {
        antiAliasing = true;
        showPath = true;
        commandDelay = 10;
        graphicsDimension = new Dimension(640, 480);
        turtleColor = new Color(160, 220, 160);
    }

    public Config() {
        URL = this.getClass().getResource("/" + PATH);
        if (URL != null) {
            try {
                KVFile file = new KVFile(URL);
                Config.load(file);
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void load(KVFile file) {
        KVTable table = file.getTable();
        antiAliasing = table.getBoolean("antiAliasing");
        showPath = table.getBoolean("showPath");
        commandDelay = table.getInteger("commandDelay");
        graphicsDimension = table.getDimension("graphicsDimension");
        turtleColor = table.getColor("turtleColor");
    }

    public static void save() {
        String str = "/* Fichier de configuration - GeoTortue v0.12 */\n";
        str = String.valueOf(str) + "antiAliasing=" + antiAliasing + "\n";
        str = String.valueOf(str) + "showPath=" + showPath + "\n";
        str = String.valueOf(str) + "commandDelay=" + commandDelay + "\n";
        str = String.valueOf(str) + "graphicsDimension=" + Config.stringOf(graphicsDimension) + "\n";
        str = String.valueOf(str) + "turtleColor=" + Config.stringOf(turtleColor) + "\n";
        str = String.valueOf(str) + "syntaxNormalColor=" + Config.stringOf(StyleConstants.getForeground(SyntaxStyles.normal)) + "\n";
        str = String.valueOf(str) + "syntaxCommentColor=" + Config.stringOf(StyleConstants.getForeground(SyntaxStyles.comment)) + "\n";
        str = String.valueOf(str) + "syntaxKeywordColor=" + Config.stringOf(StyleConstants.getForeground(SyntaxStyles.keyword)) + "\n";
        str = String.valueOf(str) + "syntaxCommandColor=" + Config.stringOf(StyleConstants.getForeground(SyntaxStyles.command)) + "\n";
        str = String.valueOf(str) + "syntaxProcedureColor=" + Config.stringOf(StyleConstants.getForeground(SyntaxStyles.procedure)) + "\n";
        str = String.valueOf(str) + "syntaxArgumentColor=" + Config.stringOf(StyleConstants.getForeground(SyntaxStyles.argument)) + "\n";
        str = String.valueOf(str) + "syntaxVariableColor=" + Config.stringOf(StyleConstants.getForeground(SyntaxStyles.variable)) + "\n";
        File file = new File(PATH);
        try {
            FileWriter writer = new FileWriter(file);
            writer.flush();
            writer.write(str);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String stringOf(Dimension d) {
        return "(" + d.width + ", " + d.height + ")";
    }

    private static String stringOf(Color c) {
        return "[r:" + c.getRed() + ", g:" + c.getGreen() + ", b:" + c.getBlue() + "]";
    }
}

