/*
 * Decompiled with CFR 0.152.
 */
package files;

import files.AbstractFile;
import files.HTMLExceptionFile;
import files.KVFile;
import files.KVTable;
import java.io.FileNotFoundException;
import java.net.URL;

public class Translator {
    private static KVTable table = new KVTable();

    public static void build(URL ... urls) {
        table.put("", "");
        URL[] uRLArray = urls;
        int n = 0;
        int n2 = uRLArray.length;
        while (n < n2) {
            URL url = uRLArray[n];
            try {
                Translator.put(url);
            }
            catch (FileNotFoundException e) {
                System.out.println("Fichier " + url + " absent !");
                System.out.println(e);
            }
            ++n;
        }
    }

    public static void put(URL url) throws FileNotFoundException {
        AbstractFile file;
        if (url.getFile().endsWith(".csv")) {
            file = new KVFile(url);
            ((KVFile)file).putContentIn(table);
        }
        if (url.getFile().endsWith(".html")) {
            file = new HTMLExceptionFile(url);
            ((HTMLExceptionFile)file).putContentIn(table);
        }
    }

    public static String get(String key) {
        if (table.get(key) != null) {
            return table.get(key);
        }
        System.out.println("Pas de traduction pour : " + key);
        table.put(key, "/" + key);
        return "/" + key;
    }

    public static String get(String key, String ... labels) {
        int n = labels.length;
        String str = Translator.get(String.valueOf(key) + "[" + n + "]");
        int idx = 0;
        while (idx < n) {
            str = str.replaceAll("#" + (idx + 1), labels[idx]);
            ++idx;
        }
        return str;
    }
}

