/*
 * Decompiled with CFR 0.152.
 */
package files;

import exceptions.LowWeightException;
import java.util.Vector;
import java.util.regex.Pattern;

public class ParsingTools {
    public static String[] split(String content, String regExp) {
        String[] lines = Pattern.compile(regExp).split(content);
        lines = ParsingTools.removeEmptyStrings(lines);
        return lines;
    }

    public static String[] splitOutOfBrackets(String text, String splitChars) throws LowWeightException {
        Vector<String> vLines = new Vector<String>();
        int idx = 0;
        int startIdx = 0;
        int bCount = 0;
        int cCount = 0;
        int sCount = 0;
        while (idx < text.length()) {
            char ch = text.charAt(idx);
            String c = String.valueOf(ch);
            if (ch == '(') {
                ++bCount;
            }
            if (ch == ')') {
                --bCount;
            }
            if (ch == '[') {
                ++sCount;
            }
            if (ch == ']') {
                --sCount;
            }
            if (ch == '{') {
                ++cCount;
            }
            if (ch == '}') {
                --cCount;
            }
            if (splitChars.contains(c) && bCount == 0 && sCount == 0 && cCount == 0) {
                vLines.add(text.substring(startIdx, idx));
                startIdx = idx + 1;
            }
            ++idx;
        }
        vLines.add(text.substring(startIdx, idx));
        ParsingTools.testBracketCount(bCount, sCount, cCount);
        String[] lines = vLines.toArray(new String[vLines.size()]);
        lines = ParsingTools.removeEmptyStrings(lines);
        return lines;
    }

    public static String trimBrackets(String text) {
        text = text.trim();
        int n = text.length();
        if (text.startsWith("(") && text.endsWith(")")) {
            return ParsingTools.trimBrackets(text.substring(1, n - 1));
        }
        if (text.startsWith("[") && text.endsWith("]")) {
            return ParsingTools.trimBrackets(text.substring(1, n - 1));
        }
        if (text.startsWith("{") && text.endsWith("}")) {
            return ParsingTools.trimBrackets(text.substring(1, n - 1));
        }
        return text;
    }

    private static void testBracketCount(int bCount, int sCount, int cCount) throws LowWeightException {
        if (bCount > 0) {
            throw new LowWeightException("missing)", new String[0]);
        }
        if (bCount < 0) {
            throw new LowWeightException("missing(", new String[0]);
        }
        if (sCount > 0) {
            throw new LowWeightException("missing]", new String[0]);
        }
        if (sCount < 0) {
            throw new LowWeightException("missing[", new String[0]);
        }
        if (cCount > 0) {
            throw new LowWeightException("missing}", new String[0]);
        }
        if (cCount < 0) {
            throw new LowWeightException("missing{", new String[0]);
        }
    }

    public static String removeJavaComments(String content) {
        content = ParsingTools.removeBlockComments(content, "/*", "*/");
        content = ParsingTools.removeEndLineComments(content, "//");
        return content;
    }

    public static String removeBlockComments(String content, String startMark, String endMark) {
        int openIdx = content.indexOf(startMark);
        if (openIdx != -1) {
            int closeIdx = content.indexOf(endMark, openIdx);
            if (closeIdx == -1) {
                return "";
            }
            content = content.replace(content.substring(openIdx, closeIdx + 2), "");
            return ParsingTools.removeBlockComments(content, startMark, endMark);
        }
        return content;
    }

    public static String removeEndLineComments(String content, String mark) {
        int commentIdx = content.indexOf(mark);
        if (commentIdx != -1) {
            int endIdx = content.indexOf("\n", commentIdx);
            content = endIdx == -1 ? content.substring(0, commentIdx) : content.replace(content.substring(commentIdx, endIdx + 1), "");
            return ParsingTools.removeEndLineComments(content, mark);
        }
        return content;
    }

    public static String[] removeEmptyStrings(String[] lines) {
        Vector<String> vector = new Vector<String>(lines.length);
        int idx = 0;
        while (idx < lines.length) {
            String line = lines[idx];
            if (line.trim().length() > 0) {
                vector.add(line);
            }
            ++idx;
        }
        vector.trimToSize();
        return vector.toArray(new String[vector.size()]);
    }

    public static int countRepsAtBegin(String str, String exp) {
        if (str.startsWith(exp)) {
            return 1 + ParsingTools.countRepsAtBegin(str.substring(1), exp);
        }
        return 0;
    }
}

