/*
 * Decompiled with CFR 0.152.
 */
package code;

import code.SyntaxStyles;
import java.util.HashSet;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;

public class SyntaxDocument
extends DefaultStyledDocument {
    private static final long serialVersionUID = 4218280162730845972L;
    private Element rootElement;
    protected static MutableAttributeSet normal = SyntaxStyles.normal;
    protected static MutableAttributeSet keyword = SyntaxStyles.keyword;
    protected static MutableAttributeSet command = SyntaxStyles.command;
    protected static MutableAttributeSet comment = SyntaxStyles.comment;
    protected static MutableAttributeSet quote = SyntaxStyles.quote;
    protected HashSet<String> keywords = new HashSet();
    protected HashSet<String> commands = new HashSet();

    public SyntaxDocument() {
        this.rootElement = this.getDefaultRootElement();
        this.putProperty("__EndOfLine__", "\n");
    }

    public void setFontFamily(String fam) {
        StyleConstants.setFontFamily(normal, fam);
    }

    public void setFontSize(int size) {
        StyleConstants.setFontSize(normal, size);
    }

    public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
        super.insertString(offset, str, a);
        this.processChangedLines(offset, str.length());
    }

    public void remove(int offset, int length) throws BadLocationException {
        super.remove(offset, length);
        this.processChangedLines(offset, 0);
    }

    public void processChangedLines(int offset, int length) throws BadLocationException {
        String content = this.getText(0, this.getLength());
        int startLine = this.rootElement.getElementIndex(offset);
        int endLine = this.rootElement.getElementIndex(offset + length);
        int i = startLine;
        while (i <= endLine) {
            this.applyHighlighting(content, i);
            ++i;
        }
    }

    private void applyHighlighting(String content, int line) throws BadLocationException {
        int startOffset = this.rootElement.getElement(line).getStartOffset();
        int endOffset = this.rootElement.getElement(line).getEndOffset() - 1;
        int lineLength = endOffset - startOffset;
        int contentLength = content.length();
        if (endOffset >= contentLength) {
            endOffset = contentLength - 1;
        }
        this.setCharacterAttributes(startOffset, lineLength, normal, true);
        int index = content.indexOf("//", startOffset);
        if (index > -1 && index < endOffset) {
            this.setCharacterAttributes(index, endOffset - index + 1, comment, false);
            endOffset = index - 1;
        }
        this.checkForTokens(content, startOffset, endOffset);
    }

    /*
     * Unable to fully structure code
     */
    private void checkForTokens(String content, int startOffset, int endOffset) {
        ** GOTO lbl9
        {
            if (startOffset < endOffset) {
                ++startOffset;
            } else {
                return;
            }
            do {
                if (this.isDelimiter(content.substring(startOffset, startOffset + 1))) continue block0;
                startOffset = this.isQuoteDelimiter(content.substring(startOffset, startOffset + 1)) != false ? this.getQuoteToken(content, startOffset, endOffset) : this.getOtherToken(content, startOffset, endOffset);
lbl9:
                // 2 sources

            } while (startOffset <= endOffset);
        }
    }

    private int getQuoteToken(String content, int startOffset, int endOffset) {
        String quoteDelimiter = content.substring(startOffset, startOffset + 1);
        int endOfQuote = content.indexOf(quoteDelimiter, startOffset + 1);
        if (endOfQuote < 0) {
            endOfQuote = endOffset;
        }
        this.setCharacterAttributes(startOffset, endOfQuote - startOffset + 1, quote, false);
        return endOfQuote + 1;
    }

    private int getOtherToken(String content, int startOffset, int endOffset) {
        int endOfToken = startOffset + 1;
        while (endOfToken <= endOffset) {
            if (this.isDelimiter(content.substring(endOfToken, endOfToken + 1))) break;
            ++endOfToken;
        }
        String token = content.substring(startOffset, endOfToken);
        int tokenLength = endOfToken - startOffset;
        this.paintToken(token, startOffset, tokenLength);
        return endOfToken + 1;
    }

    protected void paintToken(String token, int startOffset, int tokenLength) {
        if (this.keywords.contains(token)) {
            this.setCharacterAttributes(startOffset, tokenLength, keyword, false);
        } else if (this.commands.contains(token)) {
            this.setCharacterAttributes(startOffset, tokenLength, command, false);
        }
    }

    protected boolean isDelimiter(String character) {
        String operands = ";:{}()[]+-/%<=>!&|^~*";
        return Character.isWhitespace(character.charAt(0)) || operands.indexOf(character) != -1;
    }

    protected boolean isQuoteDelimiter(String character) {
        String quoteDelimiters = "\"'";
        return quoteDelimiters.indexOf(character) >= 0;
    }

    protected String getCommentTag() {
        return "//";
    }
}

