/*
 * Decompiled with CFR 0.152.
 */
package code;

import code.CommandManager2;
import code.Procedure;
import code.ProcedureDoc;
import exceptions.LowWeightException;
import java.util.Hashtable;

public class ProcedureManager {
    protected final Hashtable<String, Procedure> table = new Hashtable();
    protected final ProcedureDoc doc;
    CommandManager2 commandManager;
    protected String startTag = "pour";
    protected String endTag = "fin";

    public ProcedureManager(CommandManager2 cm, ProcedureDoc doc) {
        this.commandManager = cm;
        this.doc = doc;
    }

    public void processProc(String key, String ... args) throws LowWeightException {
        if (!this.containsKey(key)) {
            this.parse();
        }
        if (!this.containsKey(key)) {
            throw new LowWeightException("noSuchCommand", key);
        }
        this.table.get(key).execute(args);
    }

    public void parse() throws LowWeightException {
        this.clear();
        for (String text : this.doc.parse()) {
            Procedure proc = new Procedure(this.commandManager, text.substring(this.startTag.length()));
            this.table.put(proc.key, proc);
            this.doc.procedures.add(proc.key);
            this.commandManager.commandDoc.procedures.add(proc.key);
        }
    }

    public void clear() {
        this.table.clear();
        this.doc.procedures.clear();
        this.commandManager.commandDoc.procedures.clear();
    }

    public String[] getKeys() {
        return this.table.keySet().toArray(new String[this.table.size()]);
    }

    public boolean containsKey(String key) {
        return this.table.containsKey(key);
    }
}

