/*
 * Decompiled with CFR 0.152.
 */
package code;

import code.CommandManager2;
import code.DefaultCommandLineParser;
import exceptions.LowWeightException;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Procedure {
    protected String key;
    protected String[] arguments;
    protected String body = "";
    protected CommandManager2 commandManager;

    public Procedure(CommandManager2 cm, String text) throws LowWeightException {
        this.commandManager = cm;
        DefaultCommandLineParser parser = Procedure.getHeader(text);
        this.key = this.commandManager.getSymbol(parser.getKey());
        this.arguments = parser.getArgs();
        if (text.indexOf("\n") > 0) {
            this.body = text.substring(text.indexOf("\n"));
        }
    }

    public static DefaultCommandLineParser getHeader(String str) {
        int endIdx = str.indexOf("\n");
        String header = endIdx < 0 ? str : str.substring(0, endIdx);
        return new DefaultCommandLineParser(header);
    }

    public void execute(String ... args) throws LowWeightException {
        this.commandManager.testArity(args, this.arguments.length, this.key);
        String[] newArgs = this.getNumericalArguments(args);
        this.commandManager.process(this.evaluate(newArgs));
    }

    protected String[] getNumericalArguments(String ... args) {
        String[] newArgs = new String[args.length];
        int idx = 0;
        while (idx < args.length) {
            newArgs[idx] = this.commandManager.evaluate(args[idx]);
            ++idx;
        }
        return newArgs;
    }

    protected String evaluate(String ... args) throws LowWeightException {
        Hashtable<String, String> table = new Hashtable<String, String>();
        int idx = 0;
        while (idx < args.length) {
            table.put(this.arguments[idx], args[idx]);
            ++idx;
        }
        String newBody = "";
        for (String str : this.split()) {
            newBody = table.containsKey(str) ? String.valueOf(newBody) + (String)table.get(str) : String.valueOf(newBody) + str;
        }
        return newBody;
    }

    private Vector<String> split() {
        return this.split(0, new Vector<String>());
    }

    private Vector<String> split(int startIdx, Vector<String> list) {
        if (startIdx < 0) {
            return list;
        }
        String splitArg = null;
        int splitPoint = this.body.length();
        int idx = 0;
        while (idx < this.arguments.length) {
            int possibleSplit = this.getNextArgIdx(this.arguments[idx], startIdx);
            if (possibleSplit > -1 && possibleSplit < splitPoint) {
                splitPoint = possibleSplit;
                splitArg = this.arguments[idx];
            }
            ++idx;
        }
        if (splitArg == null) {
            list.addElement(this.body.substring(startIdx));
            return list;
        }
        String stringBefore = this.body.substring(startIdx, splitPoint);
        int nextStartIdx = splitPoint + splitArg.length();
        list.addElement(stringBefore);
        list.addElement(splitArg);
        return this.split(nextStartIdx, list);
    }

    private int getNextArgIdx(String arg, int startIdx) {
        int idx = this.body.indexOf(arg, startIdx);
        if (idx < 0) {
            return -1;
        }
        if (this.isAnArgumentInstance(idx)) {
            return idx;
        }
        return this.getNextArgIdx(arg, idx + 1);
    }

    private boolean isAnArgumentInstance(int index) {
        int idx = 0;
        while (idx < this.arguments.length) {
            if (this.matchArgAt(this.arguments[idx], index)) {
                return true;
            }
            ++idx;
        }
        return false;
    }

    private boolean matchArgAt(String arg, int idx) {
        if (!this.body.substring(idx).startsWith(arg)) {
            return false;
        }
        if (idx == 0) {
            char nextChar = this.body.charAt(idx + arg.length());
            return !Character.isLetterOrDigit(nextChar);
        }
        if (idx + arg.length() == this.body.length()) {
            char previousChar = this.body.charAt(idx - 1);
            return !Character.isLetterOrDigit(previousChar);
        }
        char previousChar = this.body.charAt(idx - 1);
        char nextChar = this.body.charAt(idx + arg.length());
        if (Character.isLetterOrDigit(previousChar)) {
            return false;
        }
        return !Character.isLetterOrDigit(nextChar);
    }
}

