/*
 * Decompiled with CFR 0.152.
 */
package code;

import code.HighlightEditorKit;
import files.Translator;
import gui.IconFactory;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.DefaultEditorKit;

public class HighlightTextPane
extends JTextPane
implements CaretListener,
MouseListener {
    private static final long serialVersionUID = -4419459534337649057L;
    protected HighlightEditorKit kit = new HighlightEditorKit();
    private Icon copyIcon;
    private Icon cutIcon;
    private Icon pasteIcon;

    public HighlightTextPane() {
        this.setEditorKit(this.kit);
        this.addCaretListener(this);
        this.addMouseListener(this);
        IconFactory iconFactory = new IconFactory();
        this.copyIcon = iconFactory.get("copy");
        this.cutIcon = iconFactory.get("cut");
        this.pasteIcon = iconFactory.get("paste");
    }

    public void caretUpdate(CaretEvent e) {
        this.kit.setCaretLocation(e.getDot());
        this.repaint();
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 3) {
            JPopupMenu popup = new JPopupMenu();
            JMenuItem copy = new JMenuItem(new DefaultEditorKit.CopyAction());
            JMenuItem cut = new JMenuItem(new DefaultEditorKit.CutAction());
            JMenuItem paste = new JMenuItem(new DefaultEditorKit.PasteAction());
            if (this.getSelectedText() == null) {
                copy.setEnabled(false);
                cut.setEnabled(false);
            }
            copy.setAccelerator(KeyStroke.getKeyStroke(67, 2));
            cut.setAccelerator(KeyStroke.getKeyStroke(88, 2));
            paste.setAccelerator(KeyStroke.getKeyStroke(86, 2));
            copy.setIcon(this.copyIcon);
            cut.setIcon(this.cutIcon);
            paste.setIcon(this.pasteIcon);
            copy.setText(Translator.get("copy"));
            cut.setText(Translator.get("cut"));
            paste.setText(Translator.get("paste"));
            popup.add(copy);
            popup.add(cut);
            popup.add(paste);
            popup.show(this, e.getX(), e.getY());
        }
    }

    public void mousePressed(MouseEvent arg0) {
    }

    public void mouseReleased(MouseEvent arg0) {
    }

    public void mouseEntered(MouseEvent arg0) {
    }

    public void mouseExited(MouseEvent arg0) {
    }
}

