/*
 * Decompiled with CFR 0.152.
 */
package code;

import gui.FontFactory;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.LabelView;
import javax.swing.text.ParagraphView;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class HighlightEditorKit
extends StyledEditorKit {
    private static final long serialVersionUID = -194084512589826515L;
    private int caretLocation = 0;
    private Color highlightColor = new Color(230, 245, 255);
    private Color highlightBorderColor = new Color(185, 200, 210);
    private Font font = FontFactory.ITALIC10;
    private boolean showNumbers = true;
    private short leftOffset = (short)32;
    private Color numbersColor = new Color(120, 120, 150);
    private boolean showPrompt = true;
    private String promptString = ":";

    public ViewFactory getViewFactory() {
        return new HighlightViewFactory();
    }

    public void setCaretLocation(int n) {
        this.caretLocation = n;
    }

    public void setHighlightColor(Color color) {
        this.highlightColor = color;
    }

    public void setHighlightBorderColor(Color color) {
        this.highlightBorderColor = color;
    }

    public void showNumbers(boolean b) {
        this.showNumbers = b;
    }

    public void setNumbersColor(Color color) {
        this.numbersColor = color;
    }

    public void setLeftOffset(short leftOffset) {
        this.leftOffset = leftOffset;
    }

    public void setNumbersFont(Font numbersFont) {
        this.font = numbersFont;
    }

    public void showPrompt(boolean b) {
        this.showPrompt = b;
    }

    public void setPromptString(String promptString) {
        this.promptString = promptString;
    }

    private class HighlightViewFactory
    implements ViewFactory {
        HighlightViewFactory() {
        }

        public View create(Element elem) {
            String kind = elem.getName();
            if (kind != null) {
                if (kind.equals("content")) {
                    return new LabelView(elem);
                }
                if (kind.equals("paragraph")) {
                    return new HighlightView(elem);
                }
                if (kind.equals("section")) {
                    return new BoxView(elem, 1);
                }
                if (kind.equals("component")) {
                    return new ComponentView(elem);
                }
                if (kind.equals("icon")) {
                    return new IconView(elem);
                }
            }
            return new LabelView(elem);
        }
    }

    private class HighlightView
    extends ParagraphView {
        HighlightView(Element elem) {
            super(elem);
            this.setInsets();
        }

        public void setInsets() {
            short top = 0;
            short left = this.getLeftOffset();
            short bottom = 0;
            short right = 0;
            this.setInsets(top, left, bottom, right);
        }

        public void paint(Graphics g, Shape allocation) {
            Rectangle alloc = allocation instanceof Rectangle ? (Rectangle)allocation : allocation.getBounds();
            this.setInsets();
            this.setSize(alloc.width, alloc.height);
            alloc.x += this.getLeftOffset();
            alloc.width -= this.getLeftOffset();
            int idx = 0;
            while (idx < this.getViewCount()) {
                View v = this.getView(idx);
                if (v.getStartOffset() <= HighlightEditorKit.this.caretLocation && HighlightEditorKit.this.caretLocation < v.getEndOffset()) {
                    g.setColor(HighlightEditorKit.this.highlightColor);
                    g.fillRect(alloc.x, alloc.y, alloc.width, alloc.height);
                    g.setColor(HighlightEditorKit.this.highlightBorderColor);
                    g.drawRect(alloc.x - 1, alloc.y - 1, alloc.width + 1, alloc.height + 1);
                }
                ++idx;
            }
            g.setColor(HighlightEditorKit.this.numbersColor);
            g.setFont(HighlightEditorKit.this.font);
            if (HighlightEditorKit.this.showNumbers) {
                int previousLineCount = this.getLineCount();
                g.drawString(Integer.toString(previousLineCount), 5, alloc.y + HighlightEditorKit.this.font.getSize() + 2);
            }
            if (HighlightEditorKit.this.showPrompt) {
                g.drawString(HighlightEditorKit.this.promptString, HighlightEditorKit.this.leftOffset - 8, alloc.y + HighlightEditorKit.this.font.getSize() + 1);
            }
            alloc.x -= this.getLeftOffset();
            super.paint(g, alloc);
        }

        private short getLeftOffset() {
            if (HighlightEditorKit.this.showNumbers || HighlightEditorKit.this.showPrompt) {
                return HighlightEditorKit.this.leftOffset;
            }
            return 0;
        }

        private int getLineCount() {
            int lineCount = 0;
            View parent = this.getParent();
            int idx = 0;
            while (idx < parent.getViewCount()) {
                if (parent.getView(idx) == this) break;
                ++lineCount;
                ++idx;
            }
            return lineCount + 1;
        }
    }
}

