/*
 * Decompiled with CFR 0.152.
 */
package code;

import exceptions.LowWeightException;
import files.ParsingTools;
import java.util.Vector;

public class CommandParser {
    protected String line;

    public CommandParser(String str) {
        this.line = ParsingTools.trimBrackets(str);
    }

    public boolean isEmpty() {
        return this.line.length() < 1;
    }

    public String getKey() {
        int idx = this.line.indexOf(" ");
        if (idx != -1) {
            return this.line.substring(0, idx);
        }
        return this.line;
    }

    public String[] getArgs() throws LowWeightException {
        String[] tokens = ParsingTools.splitOutOfBrackets(this.line, " ");
        Vector<String> argsV = new Vector<String>();
        String[] stringArray = tokens;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String token = stringArray[n];
            String arg = token.trim();
            if (arg.length() > 0) {
                argsV.add(token);
            }
            ++n;
        }
        argsV.removeElementAt(0);
        String[] args = argsV.toArray(new String[argsV.size()]);
        return args;
    }

    public void handleAssignments() {
        int idx = this.line.indexOf(":=");
        if (idx > -1) {
            String left = this.line.substring(0, idx).trim();
            String[] leftTokens = ParsingTools.split(left, "[\n \\[\\](){};]");
            String lToken = leftTokens[leftTokens.length - 1];
            this.line = this.line.replace(String.valueOf(lToken) + ":=", "assign " + lToken + " ");
        }
    }
}

