/*
 * Decompiled with CFR 0.152.
 */
package code;

import code.CommandLineDoc;
import code.CommandManager;
import exceptions.LowWeightException;
import jep.JEP;

public class CommandManager2
extends CommandManager {
    protected JEP jep = new JEP();

    public CommandManager2(CommandLineDoc doc) {
        super(doc);
        this.jep.addStandardFunctions();
        this.jep.addStandardConstants();
    }

    public void testArity(String[] args, int n, String key) throws LowWeightException {
        if (args.length != n) {
            throw new LowWeightException("badArity", key, String.valueOf(n));
        }
    }

    public String getSymbol(String str) throws LowWeightException {
        String operands = ";:{}()[]+-/%<=>!&|^~*";
        int idx = 0;
        while (idx < operands.length()) {
            if (str.indexOf(operands.charAt(idx)) > 0) {
                throw new LowWeightException("badSymbol", str);
            }
            ++idx;
        }
        try {
            new Double(str);
        }
        catch (NumberFormatException ex) {
            return str;
        }
        throw new LowWeightException("badSymbol", str);
    }

    public double getNumber(String str) throws LowWeightException {
        this.jep.parseExpression(str);
        if (this.jep.hasError()) {
            throw new LowWeightException("badExpression", str);
        }
        return this.jep.getValue();
    }

    public int getInteger(String str) throws LowWeightException {
        double x = this.getNumber(str);
        return (int)x;
    }

    public boolean isANumber(String str) {
        this.jep.parseExpression(str);
        return !this.jep.hasError();
    }

    public String evaluate(String str) {
        if (this.isANumber(str)) {
            try {
                return String.valueOf(this.getNumber(str));
            }
            catch (LowWeightException lowWeightException) {
                // empty catch block
            }
        }
        return str;
    }
}

