/*
 * Decompiled with CFR 0.152.
 */
package code;

import code.CommandLineDoc;
import code.CommandParser;
import exceptions.LowWeightException;
import files.ParsingTools;
import files.Translator;
import java.util.EventListener;
import java.util.Hashtable;
import javax.swing.JOptionPane;
import javax.swing.event.EventListenerList;

public class CommandManager {
    protected final Hashtable<String, Command> table;
    protected final CommandLineDoc commandDoc;
    protected boolean interrupted = false;
    private final EventListenerList listeners = new EventListenerList();

    public CommandManager(CommandLineDoc doc) {
        this.table = new Hashtable();
        this.commandDoc = doc;
    }

    public CommandLineDoc getCommandDoc() {
        return this.commandDoc;
    }

    public boolean containsKey(String key) {
        return this.table.containsKey(key);
    }

    protected Command getCommand(String key) throws LowWeightException {
        Command command = this.table.get(key.toLowerCase());
        if (command != null) {
            return command;
        }
        throw new LowWeightException("noSuchCommand", key);
    }

    public void process(String str) throws LowWeightException {
        str = ParsingTools.removeJavaComments(str);
        str = ParsingTools.trimBrackets(str);
        String[] stringArray = ParsingTools.splitOutOfBrackets(str, ";\n");
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String line = stringArray[n];
            this.processSingleCommand(line);
            ++n;
        }
    }

    protected void processSingleCommand(String str) throws LowWeightException {
        if (this.interrupted) {
            return;
        }
        CommandParser parser = new CommandParser(str);
        parser.handleAssignments();
        if (parser.isEmpty()) {
            return;
        }
        String key = parser.getKey();
        String[] args = parser.getArgs();
        this.executeCommand(key, args);
    }

    protected void executeCommand(String key, String ... args) throws LowWeightException {
        this.getCommand(key).execute(args);
    }

    public synchronized void launchExecution(String str) throws LowWeightException {
        try {
            this.process(str);
        }
        catch (StackOverflowError err) {
            JOptionPane.showMessageDialog(null, Translator.get("stackOverflow"), Translator.get("error"), 0);
        }
        this.commandDoc.refresh();
    }

    public void interrupt() {
        this.interrupted = true;
    }

    public void addListener(CommandManagerListener listener) {
        this.listeners.add(CommandManagerListener.class, listener);
    }

    public void removeListener(CommandManagerListener listener) {
        this.listeners.remove(CommandManagerListener.class, listener);
    }

    public CommandManagerListener[] getListeners() {
        return (CommandManagerListener[])this.listeners.getListeners(CommandManagerListener.class);
    }

    protected synchronized void fireExecutionStarted() {
        CommandManagerListener[] table = this.getListeners();
        int idx = 0;
        while (idx < table.length) {
            table[idx].executionStarted();
            ++idx;
        }
    }

    protected synchronized void fireExecutionStopped() {
        CommandManagerListener[] table = this.getListeners();
        int idx = 0;
        while (idx < table.length) {
            table[idx].executionStopped();
            ++idx;
        }
    }

    public abstract class Command {
        protected String key;

        protected Command(String key) {
            this.key = key.toLowerCase();
            CommandManager.this.table.put(this.key, this);
        }

        public abstract void execute(String ... var1) throws LowWeightException;
    }

    public class ExecutionThread
    extends Thread {
        String com;

        public ExecutionThread(String str) {
            this.com = str;
        }

        public void run() {
            CommandManager.this.fireExecutionStarted();
            CommandManager.this.interrupted = false;
            try {
                CommandManager.this.launchExecution(this.com);
            }
            catch (LowWeightException e) {
                e.displayInfo();
                this.interrupt();
            }
            CommandManager.this.fireExecutionStopped();
        }
    }

    public static interface CommandManagerListener
    extends EventListener {
        public void executionStarted();

        public void executionStopped();
    }
}

