/*
 * Decompiled with CFR 0.152.
 */
package code;

import code.CodeDocument;
import code.CommandLineDoc;
import code.CommandManager;
import code.HighlightTextPane;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.text.BadLocationException;

public class CommandLinePane
extends HighlightTextPane {
    private static final long serialVersionUID = 7761493927729138757L;
    protected CodeDocument doc;
    protected CommandManager commandManager;

    public CommandLinePane(CommandManager manager, CommandLineDoc codeDoc) {
        this.commandManager = manager;
        this.doc = codeDoc;
        this.setDocument(this.doc);
        this.kit.showNumbers(false);
        this.kit.setPromptString(">");
        this.kit.setLeftOffset((short)8);
        this.kit.showPrompt(true);
        this.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    int caretIdx = CommandLinePane.this.getCaretPosition();
                    int nextLineIdx = CommandLinePane.this.doc.getEndLineIdx(caretIdx);
                    if (e.getModifiers() == 1) {
                        CommandLinePane.this.doc.insertNewLine(caretIdx);
                    } else {
                        try {
                            CommandLinePane.this.doc.remove(CommandLinePane.this.getCaretPosition() - 1, 1);
                            --nextLineIdx;
                            CommandManager commandManager = CommandLinePane.this.commandManager;
                            commandManager.getClass();
                            CommandManager.ExecutionThread thread = new CommandManager.ExecutionThread(commandManager, CommandLinePane.this.doc.getLineAt(--caretIdx));
                            thread.start();
                        }
                        catch (BadLocationException e1) {
                            e1.printStackTrace();
                        }
                        if (nextLineIdx <= CommandLinePane.this.doc.getLength()) {
                            CommandLinePane.this.setCaretPosition(nextLineIdx);
                        } else {
                            CommandLinePane.this.doc.appendNewLine();
                            CommandLinePane.this.setCaretPosition(CommandLinePane.this.doc.getLength());
                        }
                    }
                }
            }
        });
    }
}

