/*
 * Decompiled with CFR 0.152.
 */
package code;

import code.SyntaxDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;

public class CodeDocument
extends SyntaxDocument {
    private static final long serialVersionUID = -4525586269624056370L;

    public void appendNewLine() {
        try {
            this.insertString(this.getLength(), "\n", null);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void insertNewLine(int offset) {
        try {
            this.insertString(offset, "\n", null);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public String getLineAt(int offset) {
        try {
            String content = this.getText(0, this.getLength());
            int lineIdx = this.getDefaultRootElement().getElementIndex(offset);
            Element line = this.getDefaultRootElement().getElement(lineIdx);
            int start = line.getStartOffset();
            int end = line.getEndOffset() - 1;
            return content.substring(start, end);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return "";
        }
    }

    public int getEndLineIdx(int offset) {
        int lineIdx = this.getDefaultRootElement().getElementIndex(offset);
        Element line = this.getDefaultRootElement().getElement(lineIdx);
        return line.getEndOffset();
    }

    public int getStartLineIdx(int offset) {
        int lineIdx = this.getDefaultRootElement().getElementIndex(offset);
        Element line = this.getDefaultRootElement().getElement(lineIdx);
        return line.getStartOffset();
    }

    public String getWholeText() {
        try {
            return this.getText(0, this.getLength());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return "";
        }
    }

    public void setText(String text) {
        this.removeAll();
        try {
            this.insertString(0, text, null);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void removeAll() {
        try {
            this.remove(0, this.getLength());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void refresh() {
        try {
            this.processChangedLines(0, this.getLength());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }
}

